/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Component(role=RepositoryLayoutProvider.class)
public final class DefaultRepositoryLayoutProvider
implements RepositoryLayoutProvider,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement(role=RepositoryLayoutFactory.class)
    private Collection<RepositoryLayoutFactory> factories = new ArrayList<RepositoryLayoutFactory>();
    private static final Comparator<RepositoryLayoutFactory> COMPARATOR = new Comparator<RepositoryLayoutFactory>(){

        @Override
        public int compare(RepositoryLayoutFactory o1, RepositoryLayoutFactory o2) {
            return Float.compare(o2.getPriority(), o1.getPriority());
        }
    };

    public DefaultRepositoryLayoutProvider() {
    }

    @Inject
    DefaultRepositoryLayoutProvider(Set<RepositoryLayoutFactory> layoutFactories, LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
        this.setRepositoryLayoutFactories(layoutFactories);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.setRepositoryLayoutFactories(locator.getServices(RepositoryLayoutFactory.class));
    }

    public DefaultRepositoryLayoutProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultRepositoryLayoutProvider addRepositoryLayoutFactory(RepositoryLayoutFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("layout factory has not been specified");
        }
        this.factories.add(factory);
        return this;
    }

    public DefaultRepositoryLayoutProvider setRepositoryLayoutFactories(Collection<RepositoryLayoutFactory> factories) {
        this.factories = factories == null ? new ArrayList<RepositoryLayoutFactory>() : factories;
        return this;
    }

    DefaultRepositoryLayoutProvider setFactories(List<RepositoryLayoutFactory> factories) {
        return this.setRepositoryLayoutFactories(factories);
    }

    public RepositoryLayout newRepositoryLayout(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        if (repository == null) {
            throw new IllegalArgumentException("remote repository has not been specified");
        }
        ArrayList<RepositoryLayoutFactory> factories = new ArrayList<RepositoryLayoutFactory>(this.factories);
        Collections.sort(factories, COMPARATOR);
        ArrayList<NoRepositoryLayoutException> errors = new ArrayList<NoRepositoryLayoutException>();
        for (RepositoryLayoutFactory factory : factories) {
            try {
                RepositoryLayout repositoryLayout = factory.newInstance(session, repository);
                return repositoryLayout;
            }
            catch (NoRepositoryLayoutException noRepositoryLayoutException) {
                errors.add(noRepositoryLayoutException);
            }
        }
        if (this.logger.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain layout factory for " + repository;
            for (Exception exception : errors) {
                this.logger.debug(msg, (Throwable)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No layout factories registered");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available layout factories: ");
            ListIterator it = factories.listIterator();
            while (it.hasNext()) {
                RepositoryLayoutFactory repositoryLayoutFactory = (RepositoryLayoutFactory)it.next();
                buffer.append(repositoryLayoutFactory.getClass().getSimpleName());
                if (!it.hasNext()) continue;
                buffer.append(", ");
            }
        }
        throw new NoRepositoryLayoutException(repository, buffer.toString(), errors.size() == 1 ? (NoRepositoryLayoutException)((Object)errors.get(0)) : null);
    }
}

