/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.sorted.immutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.MutableBagIterable;
import org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.multimap.sortedbag.ImmutableSortedBagMultimap;
import org.eclipse.collections.api.partition.bag.sorted.PartitionImmutableSortedBag;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.immutable.AbstractImmutableBagIterable;
import org.eclipse.collections.impl.bag.sorted.immutable.ImmutableSortedBagSerializationProxy;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.bag.sorted.mutable.TreeBagMultimap;
import org.eclipse.collections.impl.partition.bag.sorted.PartitionTreeBag;
import org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;

abstract class AbstractImmutableSortedBag<T>
extends AbstractImmutableBagIterable<T>
implements ImmutableSortedBag<T> {
    AbstractImmutableSortedBag() {
    }

    public ImmutableSortedBag<T> newWithoutAll(Iterable<? extends T> elements) {
        return this.reject((Predicate<? super T>)Predicates.in(elements));
    }

    public ImmutableSortedBag<T> toImmutable() {
        return this;
    }

    public ImmutableSortedBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    protected Object writeReplace() {
        return new ImmutableSortedBagSerializationProxy(this);
    }

    @Override
    public <V> ImmutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.collect(function, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public <V, P> ImmutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return ((MutableBag)this.countByEach(function, (MutableBagIterable)Bags.mutable.empty())).toImmutable();
    }

    public <V> ImmutableSortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, TreeBagMultimap.newMultimap(this.comparator())).toImmutable();
    }

    public <V> ImmutableSortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, TreeBagMultimap.newMultimap(this.comparator())).toImmutable();
    }

    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap(this.size())).toImmutable();
    }

    public ImmutableSortedBag<T> select(Predicate<? super T> predicate) {
        return this.select(predicate, TreeBag.newBag(this.comparator())).toImmutable();
    }

    public <P> ImmutableSortedBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.selectWith(predicate, parameter, TreeBag.newBag(this.comparator())).toImmutable();
    }

    public ImmutableSortedBag<T> reject(Predicate<? super T> predicate) {
        return this.reject(predicate, TreeBag.newBag(this.comparator())).toImmutable();
    }

    public <P> ImmutableSortedBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.rejectWith(predicate, parameter, TreeBag.newBag(this.comparator())).toImmutable();
    }

    public PartitionImmutableSortedBag<T> partition(Predicate<? super T> predicate) {
        PartitionTreeBag result = new PartitionTreeBag(this.comparator());
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, index) -> {
            MutableSortedBag bucket = predicate.accept(each) ? result.getSelected() : result.getRejected();
            bucket.addOccurrences(each, index);
        });
        return result.toImmutable();
    }

    public <P> PartitionImmutableSortedBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionTreeBag result = new PartitionTreeBag(this.comparator());
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, index) -> {
            MutableSortedBag bucket = predicate.accept(each, parameter) ? result.getSelected() : result.getRejected();
            bucket.addOccurrences(each, index);
        });
        return result.toImmutable();
    }

    public <V> ImmutableList<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, FastList.newList()).toImmutable();
    }

    public <P, V> ImmutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, FastList.newList()).toImmutable();
    }

    public <V> ImmutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, FastList.newList()).toImmutable();
    }

    public ImmutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, new BooleanArrayList(this.size())).toImmutable();
    }

    public ImmutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, new ByteArrayList(this.size())).toImmutable();
    }

    public ImmutableCharList collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, new CharArrayList(this.size())).toImmutable();
    }

    public ImmutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, new DoubleArrayList(this.size())).toImmutable();
    }

    public ImmutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, new FloatArrayList(this.size())).toImmutable();
    }

    public ImmutableIntList collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, new IntArrayList(this.size())).toImmutable();
    }

    public ImmutableLongList collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, new LongArrayList(this.size())).toImmutable();
    }

    public ImmutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, new ShortArrayList(this.size())).toImmutable();
    }

    public <V> ImmutableList<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        return ((FastList)((Object)this.collectWithOccurrences((ObjectIntToObjectFunction)function, (Collection)((Object)FastList.newList())))).toImmutable();
    }

    public <V> ImmutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, FastList.newList()).toImmutable();
    }

    public ImmutableSortedBag<T> selectByOccurrences(IntPredicate predicate) {
        TreeBag result = TreeBag.newBag(this.comparator());
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(occurrences)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result.toImmutable();
    }

    public <S> ImmutableSortedBag<S> selectInstancesOf(Class<S> clazz) {
        Comparator comparator = this.comparator();
        TreeBag result = TreeBag.newBag(comparator);
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, occurrences) -> {
            if (clazz.isInstance(each)) {
                result.addOccurrences(clazz.cast(each), occurrences);
            }
        });
        return result.toImmutable();
    }

    public <S> ImmutableList<Pair<T, S>> zip(Iterable<S> that) {
        FastList list;
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            list = FastList.newList(Math.min(this.size(), thatSize));
        } else {
            list = FastList.newList();
        }
        Iterator iterator = that.iterator();
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, parameter) -> {
            for (int i = 0; i < parameter; ++i) {
                if (!iterator.hasNext()) continue;
                list.add(Tuples.pair(each, iterator.next()));
            }
        });
        return list.toImmutable();
    }

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        Iterator iterator = that.iterator();
        if (target instanceof MutableBag) {
            MutableBag targetBag = (MutableBag)target;
            this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, occurrences) -> {
                if (iterator.hasNext()) {
                    targetBag.addOccurrences(Tuples.pair(each, iterator.next()), occurrences);
                }
            });
        } else {
            this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, occurrences) -> {
                for (int i = 0; i < occurrences; ++i) {
                    if (!iterator.hasNext()) continue;
                    target.add(Tuples.pair(each, iterator.next()));
                }
            });
        }
        return target;
    }

    public ImmutableSortedSet<Pair<T, Integer>> zipWithIndex() {
        Object comparator = this.comparator() == null ? Comparators.naturalOrder() : this.comparator();
        TreeSortedSet pairs = TreeSortedSet.newSet(Comparators.chain(new Comparator[]{Comparators.byFunction(Functions.firstOfPair(), comparator), Comparators.byFunction(Functions.secondOfPair())}));
        return Iterate.zipWithIndex(this, pairs).toImmutable();
    }

    public ImmutableList<ObjectIntPair<T>> topOccurrences(int n) {
        return this.occurrencesSortingBy(n, (IntFunction & Serializable)item -> -item.getTwo()).toImmutable();
    }

    public ImmutableList<ObjectIntPair<T>> bottomOccurrences(int n) {
        return this.occurrencesSortingBy(n, ObjectIntPair::getTwo).toImmutable();
    }

    private MutableList<ObjectIntPair<T>> occurrencesSortingBy(int n, IntFunction<ObjectIntPair<T>> function) {
        int keySize;
        if (n < 0) {
            throw new IllegalArgumentException("Cannot use a value of n < 0");
        }
        if (n == 0) {
            return Lists.fixedSize.empty();
        }
        MutableList sorted = this.toListWithOccurrences().sortThisByInt(function);
        MutableList results = sorted.subList(0, keySize).toList();
        for (keySize = Math.min(n, this.sizeDistinct()); keySize < sorted.size() && ((ObjectIntPair)results.getLast()).getTwo() == ((ObjectIntPair)sorted.get(keySize)).getTwo(); ++keySize) {
            results.add(sorted.get(keySize));
        }
        return results;
    }

    public MutableStack<T> toStack() {
        return Stacks.mutable.withAll((Iterable)this);
    }

    public RichIterable<RichIterable<T>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        Object[] objects = this.toArray();
        TreeBag batch = TreeBag.newBag(this.comparator());
        int j = 0;
        while (j < objects.length) {
            for (int i = 0; i < size && j < objects.length; ++j, ++i) {
                batch.add(objects[j]);
            }
            result.add((Object)batch.toImmutable());
        }
        return result.toImmutable();
    }

    public ImmutableSortedBag<T> toReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toReversed() not implemented yet");
    }

    public int detectLastIndex(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectLastIndex() not implemented yet");
    }

    public LazyIterable<T> asReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asReversed() not implemented yet");
    }
}

