/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableByteStack;
import org.eclipse.collections.api.stack.primitive.MutableByteStack;
import org.eclipse.collections.impl.factory.primitive.ByteStacks;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedByteStack;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableByteStack;
import org.eclipse.collections.impl.stack.primitive.AbstractByteStack;

public class ByteArrayStack
extends AbstractByteStack
implements MutableByteStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient ByteArrayList delegate;

    public ByteArrayStack() {
        this.delegate = new ByteArrayList();
    }

    private ByteArrayStack(int size) {
        this.delegate = new ByteArrayList(size);
    }

    private ByteArrayStack(byte ... items) {
        this.delegate = new ByteArrayList(items);
    }

    public static ByteArrayStack newStackFromTopToBottom(byte ... items) {
        ByteArrayStack stack = new ByteArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static ByteArrayStack newStackWith(byte ... items) {
        return new ByteArrayStack(items);
    }

    public static ByteArrayStack newStack(ByteIterable items) {
        ByteArrayStack stack = new ByteArrayStack(items.size());
        stack.delegate = ByteArrayList.newList(items);
        return stack;
    }

    public static ByteArrayStack newStackFromTopToBottom(ByteIterable items) {
        ByteArrayStack stack = new ByteArrayStack(items.size());
        stack.delegate = ByteArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    protected ByteArrayList getDelegate() {
        return this.delegate;
    }

    public void push(byte item) {
        this.delegate.add(item);
    }

    public byte pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    public ByteList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new ByteArrayList(0);
        }
        ByteArrayList subList = new ByteArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    public MutableByteStack select(BytePredicate predicate) {
        return ByteArrayStack.newStackFromTopToBottom((ByteIterable)this.delegate.asReversed().select(predicate));
    }

    public MutableByteStack reject(BytePredicate predicate) {
        return ByteArrayStack.newStackFromTopToBottom((ByteIterable)this.delegate.asReversed().reject(predicate));
    }

    public <V> MutableStack<V> collect(ByteToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public void clear() {
        this.delegate.clear();
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newList((ByteIterable)this).sortThis();
    }

    public MutableByteStack asUnmodifiable() {
        return new UnmodifiableByteStack(this);
    }

    public MutableByteStack asSynchronized() {
        return new SynchronizedByteStack(this);
    }

    public ImmutableByteStack toImmutable() {
        return ByteStacks.immutable.withAll((ByteIterable)this.delegate);
    }

    public ByteArrayStack newEmpty() {
        return new ByteArrayStack();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        ByteIterator iterator = this.delegate.asReversed().byteIterator();
        while (iterator.hasNext()) {
            byte each = iterator.next();
            out.writeByte(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        byte[] array = new byte[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readByte();
        }
        this.delegate = ByteArrayList.newListWith(array);
    }
}

