/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongCharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableLongCharMap;
import org.eclipse.collections.api.map.primitive.LongCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongCharPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongCharMaps;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.LongCharHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableLongCharSingletonMap
implements ImmutableLongCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\u0000';
    private final long key1;
    private final char value1;

    ImmutableLongCharSingletonMap(long key1, char value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public char get(long key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getIfAbsent(long key, char ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public char getOrThrow(long key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key) {
        return this.key1 == key;
    }

    public boolean containsValue(char value) {
        return this.value1 == value;
    }

    public void forEachValue(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(LongProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(LongCharProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyLongIterable keysView() {
        return LongLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<LongCharPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableLongCharMap select(LongCharPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? LongCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new LongCharHashMap().toImmutable();
    }

    public ImmutableLongCharMap reject(LongCharPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new LongCharHashMap().toImmutable() : LongCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableLongCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return new UnmodifiableCharIterator((CharIterator)LongCharHashMap.newWithKeysValues(this.key1, this.value1).charIterator());
    }

    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(CharPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public char min() {
        return this.value1;
    }

    public char max() {
        return this.value1;
    }

    public char maxIfEmpty(char defaultValue) {
        return this.value1;
    }

    public char minIfEmpty(char defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public char[] toSortedArray() {
        return new char[]{this.value1};
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableCharCollection select(CharPredicate predicate) {
        return predicate.accept(this.value1) ? CharArrayList.newListWith(this.value1).toImmutable() : new CharArrayList().toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate) {
        return predicate.accept(this.value1) ? new CharArrayList().toImmutable() : CharArrayList.newListWith(this.value1).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public char[] toArray() {
        return new char[]{this.value1};
    }

    public boolean contains(char value) {
        return this.value1 == value;
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableCharList toList() {
        return CharArrayList.newListWith(this.value1);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSetWith(this.value1);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBagWith(this.value1);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableLongCharMap newWithKeyValue(long key, char value) {
        return LongCharMaps.immutable.withAll((LongCharMap)LongCharHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableLongCharMap newWithoutKey(long key) {
        return this.key1 == key ? LongCharMaps.immutable.with() : this;
    }

    public ImmutableLongCharMap newWithoutAllKeys(LongIterable keys) {
        return keys.contains(this.key1) ? LongCharMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(LongHashSet.newSetWith(this.key1));
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of((MutableCharCollection)CharArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongCharMap)) {
            return false;
        }
        LongCharMap map = (LongCharMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (int)(this.key1 ^ this.key1 >>> 32) ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

