/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.set;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.set.ImmutableSetMultimap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.AbstractMutableMultimap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.multimap.set.ImmutableSetMultimapImpl;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableSetMultimap<K, V>
extends AbstractMutableMultimap<K, V, MutableSet<V>>
implements MutableSetMultimap<K, V> {
    protected AbstractMutableSetMultimap() {
    }

    protected AbstractMutableSetMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    protected AbstractMutableSetMultimap(Iterable<Pair<K, V>> inputIterable) {
        super(inputIterable);
    }

    protected AbstractMutableSetMultimap(int size) {
        super(size);
    }

    public MutableSetMultimap<K, V> toMutable() {
        return new UnifiedSetMultimap(this);
    }

    public ImmutableSetMultimap<K, V> toImmutable() {
        final UnifiedMap map = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, MutableSet<V>>(){

            public void value(K key, MutableSet<V> set) {
                map.put(key, (Object)set.toImmutable());
            }
        });
        return new ImmutableSetMultimapImpl(map);
    }

    public <K2, V2> MutableBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap());
    }

    public <V2> MutableBagMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, HashBagMultimap.newMultimap());
    }
}

