/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.DoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedDoubleIntProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;

final class ImmutableDoubleHashBag
implements ImmutableDoubleBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleBag delegate;

    private ImmutableDoubleHashBag(double[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = DoubleHashBag.newBagWith(newElements);
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use DoubleBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableDoubleHashBag newBagWith(double ... elements) {
        return new ImmutableDoubleHashBag(elements);
    }

    public ImmutableDoubleBag newWith(double element) {
        return DoubleHashBag.newBag((DoubleBag)this.delegate).with(element).toImmutable();
    }

    public ImmutableDoubleBag newWithout(double element) {
        DoubleHashBag hashBag = DoubleHashBag.newBag((DoubleBag)this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    public ImmutableDoubleBag newWithAll(DoubleIterable elements) {
        DoubleHashBag bag = DoubleHashBag.newBag((DoubleBag)this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    public ImmutableDoubleBag newWithoutAll(DoubleIterable elements) {
        DoubleHashBag bag = DoubleHashBag.newBag((DoubleBag)this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public boolean contains(double value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(double ... elements) {
        return this.delegate.containsAll(elements);
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public ImmutableDoubleBag select(DoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleBag selectByOccurrences(IntPredicate predicate) {
        return this.delegate.selectByOccurrences(predicate).toImmutable();
    }

    public ImmutableDoubleSet selectUnique() {
        MutableDoubleSet result = DoubleSets.mutable.empty();
        this.forEachWithOccurrences((DoubleIntProcedure & Serializable)(each, occurrences) -> {
            if (occurrences == 1) {
                result.add(each);
            }
        });
        return result.toImmutable();
    }

    public ImmutableList<DoubleIntPair> topOccurrences(int count) {
        return this.delegate.topOccurrences(count).toImmutable();
    }

    public ImmutableList<DoubleIntPair> bottomOccurrences(int count) {
        return this.delegate.bottomOccurrences(count).toImmutable();
    }

    public ImmutableDoubleBag reject(DoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public MutableDoubleList toList() {
        return this.delegate.toList();
    }

    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    public int occurrencesOf(double item) {
        return this.delegate.occurrencesOf(item);
    }

    public void forEachWithOccurrences(DoubleIntProcedure doubleIntProcedure) {
        this.delegate.forEachWithOccurrences(doubleIntProcedure);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public int count(DoublePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public double sum() {
        return this.delegate.sum();
    }

    public double min() {
        return this.delegate.min();
    }

    public double max() {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double minIfEmpty(double defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList() {
        return this.delegate.toSortedList();
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<DoubleIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)this);
            } else {
                DoubleIterator iterator = this.doubleIterator();
                while (iterator.hasNext()) {
                    MutableDoubleBag batch = DoubleBags.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MutableDoubleSet toSet() {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag() {
        return this.delegate.toBag();
    }

    public ImmutableDoubleBag toImmutable() {
        return this;
    }

    public LazyDoubleIterable asLazy() {
        return this.delegate.asLazy();
    }

    public double[] toArray() {
        return this.delegate.toArray();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)this.delegate.doubleIterator());
    }

    private Object writeReplace() {
        return new ImmutableDoubleBagSerializationProxy((DoubleBag)this);
    }

    protected static class ImmutableDoubleBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleBag bag;

        public ImmutableDoubleBagSerializationProxy() {
        }

        protected ImmutableDoubleBagSerializationProxy(DoubleBag bag) {
            this.bag = bag;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences((DoubleIntProcedure)new CheckedDoubleIntProcedure(){

                    @Override
                    public void safeValue(double item, int count) throws IOException {
                        out.writeDouble(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            DoubleHashBag deserializedBag = new DoubleHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readDouble(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

