/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharCharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.CharCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.factory.primitive.CharCharMaps;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.CharCharHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableCharCharSingletonMap
implements ImmutableCharCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\u0000';
    private final char key1;
    private final char value1;

    ImmutableCharCharSingletonMap(char key1, char value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public char get(char key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getIfAbsent(char key, char ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public char getOrThrow(char key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        return this.key1 == key;
    }

    public boolean containsValue(char value) {
        return this.value1 == value;
    }

    public void forEachValue(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(CharProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(CharCharProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyCharIterable keysView() {
        return CharLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<CharCharPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableCharCharMap flipUniqueValues() {
        return CharCharMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableCharCharMap select(CharCharPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? CharCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new CharCharHashMap().toImmutable();
    }

    public ImmutableCharCharMap reject(CharCharPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new CharCharHashMap().toImmutable() : CharCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with((Object[])new CharIterable[]{CharBags.immutable.with(this.value1)});
    }

    public ImmutableCharCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return new UnmodifiableCharIterator((CharIterator)CharCharHashMap.newWithKeysValues(this.key1, this.value1).charIterator());
    }

    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(CharPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public char min() {
        return this.value1;
    }

    public char max() {
        return this.value1;
    }

    public char maxIfEmpty(char defaultValue) {
        return this.value1;
    }

    public char minIfEmpty(char defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public char[] toSortedArray() {
        return new char[]{this.value1};
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableCharBag select(CharPredicate predicate) {
        return predicate.accept(this.value1) ? CharHashBag.newBagWith(this.value1).toImmutable() : CharBags.immutable.empty();
    }

    public ImmutableCharBag reject(CharPredicate predicate) {
        return predicate.accept(this.value1) ? CharBags.immutable.empty() : CharHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public char[] toArray() {
        return new char[]{this.value1};
    }

    public boolean contains(char value) {
        return this.value1 == value;
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableCharList toList() {
        return CharArrayList.newListWith(this.value1);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSetWith(this.value1);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBagWith(this.value1);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableCharCharMap newWithKeyValue(char key, char value) {
        return CharCharMaps.immutable.withAll((CharCharMap)CharCharHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableCharCharMap newWithoutKey(char key) {
        return this.key1 == key ? CharCharMaps.immutable.with() : this;
    }

    public ImmutableCharCharMap newWithoutAllKeys(CharIterable keys) {
        return keys.contains(this.key1) ? CharCharMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(CharHashSet.newSetWith(this.key1));
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of((MutableCharCollection)CharArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharCharMap)) {
            return false;
        }
        CharCharMap map = (CharCharMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

