/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.events.internal;

import com.google.common.base.Preconditions;
import java.util.EventObject;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.events.EventConsumer;
import org.hudsonci.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class EventPublisherImpl
implements EventPublisher {
    private static final Logger log = LoggerFactory.getLogger(EventPublisherImpl.class);
    private final List<EventConsumer> consumers;

    @Inject
    public EventPublisherImpl(List<EventConsumer> consumers) {
        this.consumers = (List)Preconditions.checkNotNull(consumers);
    }

    private EventConsumer[] getConsumers() {
        return this.consumers.toArray(new EventConsumer[this.consumers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(EventObject event) {
        Preconditions.checkNotNull((Object)event);
        log.trace("Publishing event: {}", (Object)event);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (EventConsumer target : this.getConsumers()) {
            log.trace("Firing event ({}) to consumer: {}", (Object)event, (Object)target);
            Thread.currentThread().setContextClassLoader(target.getClass().getClassLoader());
            try {
                target.consume(event);
            }
            catch (Exception e) {
                log.error("Consumer raised an exception", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }
}

