/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.events.ready;

import com.google.common.base.Preconditions;
import hudson.init.InitMilestone;
import hudson.model.Hudson;
import hudson.security.HudsonFilter;
import java.lang.reflect.Field;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.eclipse.hudson.WebAppController;
import org.hudsonci.events.EventPublisher;
import org.hudsonci.events.ready.ReadyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class ReadyDetector
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ReadyDetector.class);
    private final EventPublisher publisher;
    private final Hudson hudson;
    private final WebAppController controller;

    @Inject
    public ReadyDetector(EventPublisher publisher, Hudson hudson) {
        this.publisher = (EventPublisher)Preconditions.checkNotNull((Object)publisher);
        this.hudson = (Hudson)Preconditions.checkNotNull((Object)hudson);
        this.controller = WebAppController.get();
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (true) {
            if (this.isReady()) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for initialization; ignoring", (Throwable)e);
            }
        }
        this.publisher.publish(new ReadyEvent(this.hudson));
        log.info("Hudson is ready.");
    }

    private boolean isReady() {
        if (this.hudson.getInitLevel() != InitMilestone.COMPLETED) {
            return false;
        }
        HudsonFilter filter = HudsonFilter.get((ServletContext)this.hudson.servletContext);
        if (filter == null) {
            return false;
        }
        Filter delegate = this.getDelegate(filter);
        if (delegate == null) {
            return false;
        }
        try {
            Object app = this.controller.current();
            return app instanceof Hudson;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private Filter getDelegate(HudsonFilter filter) {
        assert (filter != null);
        try {
            Field field = filter.getClass().getDeclaredField("filter");
            field.setAccessible(true);
            return (Filter)field.get(filter);
        }
        catch (Exception e) {
            throw new Error("Failed to access HudsonFilter.filter delegate", e);
        }
    }
}

