/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.service.internal;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.security.AccessControlled;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import org.hudsonci.service.BuildNotFoundException;
import org.hudsonci.service.BuildService;
import org.hudsonci.service.ProjectService;
import org.hudsonci.service.SecurityService;
import org.hudsonci.service.ServiceRuntimeException;
import org.hudsonci.service.internal.DummyStaplerRequest;
import org.hudsonci.service.internal.DummyStaplerResponse;
import org.hudsonci.service.internal.ServicePreconditions;
import org.hudsonci.service.internal.ServiceSupport;
import org.hudsonci.utils.common.Varargs;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Named
@Singleton
public class BuildServiceImpl
extends ServiceSupport
implements BuildService {
    private final ProjectService projects;
    private final SecurityService security;

    @Inject
    BuildServiceImpl(ProjectService projects, SecurityService security) {
        this.projects = (ProjectService)Preconditions.checkNotNull((Object)projects);
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
    }

    @Override
    public void deleteBuild(AbstractProject<?, ?> project, int buildNumber) {
        AbstractBuild<?, ?> build = this.getBuild(project, buildNumber);
        this.security.checkPermission((AccessControlled)build, Run.DELETE);
        this.log.debug("Deleting build: {} #{}", (Object)project.getName(), (Object)buildNumber);
        try {
            build.delete();
        }
        catch (IOException e) {
            throw new ServiceRuntimeException("Delete failed for build " + project.getName() + " #" + buildNumber, e);
        }
    }

    @Override
    public void keepBuild(AbstractProject<?, ?> project, int buildNumber, boolean release) {
        AbstractBuild<?, ?> build = this.getBuild(project, buildNumber);
        this.security.checkPermission((AccessControlled)build, Run.UPDATE);
        this.log.debug("{} build: {} #{}", Varargs.$((Object[])new Serializable[]{release ? "Releasing" : "Keeping", project.getName(), Integer.valueOf(buildNumber)}));
        try {
            build.keepLog(!release);
        }
        catch (IOException e) {
            throw new ServiceRuntimeException((release ? "Releasing failed for build #" : "Keeping failed for build ") + project.getName() + " #" + buildNumber);
        }
    }

    public AbstractBuild<?, ?> getBuild(String projectName, int buildNumber) {
        ServicePreconditions.checkProjectName(projectName);
        ServicePreconditions.checkBuildNumber(buildNumber);
        AbstractProject<?, ?> project = this.projects.getProject(projectName);
        return this.getBuild(project, buildNumber);
    }

    public AbstractBuild<?, ?> getBuild(AbstractProject<?, ?> project, int buildNumber) throws BuildNotFoundException {
        AbstractBuild<?, ?> build = this.findBuild(project, buildNumber);
        if (build == null) {
            throw new BuildNotFoundException("Build " + project.getName() + " #" + buildNumber + " could not be found.");
        }
        return build;
    }

    public AbstractBuild<?, ?> findBuild(String projectName, int buildNumber) {
        ServicePreconditions.checkProjectName(projectName);
        ServicePreconditions.checkBuildNumber(buildNumber);
        AbstractProject<?, ?> project = this.projects.findProject(projectName);
        return project != null ? this.findBuild(project, buildNumber) : null;
    }

    public AbstractBuild<?, ?> findBuild(AbstractProject<?, ?> project, int buildNumber) {
        ServicePreconditions.checkNotNull(project, "project");
        ServicePreconditions.checkBuildNumber(buildNumber);
        AbstractBuild build = (AbstractBuild)project.getBuildByNumber(buildNumber);
        if (build != null) {
            this.security.checkPermission((AccessControlled)build, Item.READ);
        }
        return build;
    }

    @Override
    public void stopBuild(AbstractProject<?, ?> project, int buildNumber) {
        AbstractBuild<?, ?> build = this.getBuild(project, buildNumber);
        this.log.debug("Stopping build: {} #{}", (Object)project.getName(), (Object)buildNumber);
        try {
            build.doStop((StaplerRequest)DummyStaplerRequest.INSTANCE, (StaplerResponse)DummyStaplerResponse.INSTANCE);
        }
        catch (IOException e) {
            throw new ServiceRuntimeException("Stop failed for " + project.getName() + " #" + buildNumber, e);
        }
        catch (ServletException e) {
            throw new ServiceRuntimeException("Stop failed for " + project.getName() + " #" + buildNumber, e);
        }
    }
}

