/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.service.internal;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.DependencyGraph;
import hudson.model.TaskListener;
import hudson.tasks.BuildTrigger;
import javax.inject.Singleton;
import org.hudsonci.service.DependencyGraphService;
import org.hudsonci.service.internal.ServicePreconditions;
import org.hudsonci.service.internal.ServiceSupport;

@Singleton
public class DependencyGraphServiceImpl
extends ServiceSupport
implements DependencyGraphService {
    @Override
    public DependencyGraph getGraph() {
        return this.getHudson().getDependencyGraph();
    }

    @Override
    public void rebuild() {
        this.log.debug("Rebuilding dependency graph");
        this.getHudson().rebuildDependencyGraph();
    }

    @Override
    public void triggerDependents(AbstractBuild<?, ?> build, TaskListener listener) {
        ServicePreconditions.checkNotNull(build, "build");
        ServicePreconditions.checkNotNull(listener, "listener");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Maybe triggering dependents of build: {}", (Object)build.getFullDisplayName());
        }
        BuildTrigger.execute(build, (BuildListener)((BuildListener)listener));
    }
}

