/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.service.internal;

import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.service.DescriptorService;
import org.hudsonci.service.internal.ServicePreconditions;
import org.hudsonci.service.internal.ServiceSupport;

@Named
@Singleton
public class DescriptorServiceImpl
extends ServiceSupport
implements DescriptorService {
    @Inject
    DescriptorServiceImpl() {
    }

    @Override
    public Descriptor getDescriptor(String className) {
        ServicePreconditions.checkNotNull(className, "class name");
        return this.getHudson().getDescriptor(className);
    }

    @Override
    public Descriptor getDescriptor(Class<? extends Describable> type) {
        ServicePreconditions.checkNotNull(type, "type");
        return this.getHudson().getDescriptor(type);
    }

    @Override
    public Descriptor getDescriptorOrDie(Class<? extends Describable> type) {
        ServicePreconditions.checkNotNull(type, "type");
        return this.getHudson().getDescriptorOrDie(type);
    }

    @Override
    public <T extends Descriptor> T getDescriptorByType(Class<T> type) {
        ServicePreconditions.checkNotNull(type, "type");
        return (T)this.getHudson().getDescriptorByType(type);
    }

    @Override
    public <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> getDescriptorList(Class<T> type) {
        ServicePreconditions.checkNotNull(type, "type");
        return this.getHudson().getDescriptorList(type);
    }
}

