/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.service.internal;

import com.google.common.base.Preconditions;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.service.NodeNotFoundException;
import org.hudsonci.service.NodeService;
import org.hudsonci.service.SecurityService;
import org.hudsonci.service.internal.ServicePreconditions;
import org.hudsonci.service.internal.ServiceSupport;

@Named
@Singleton
public class NodeServiceImpl
extends ServiceSupport
implements NodeService {
    private final SecurityService security;

    @Inject
    public NodeServiceImpl(SecurityService security) {
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
    }

    @Override
    public Node getNode(String nodeName) {
        Node node = this.findNode(nodeName);
        if (node == null) {
            throw new NodeNotFoundException(String.format("Node %s not found.", nodeName));
        }
        return node;
    }

    @Override
    public Node findNode(String nodeName) {
        this.log.debug("findNode(\"{}\")", (Object)nodeName);
        ServicePreconditions.checkNodeName(nodeName);
        Object node = "".equals(nodeName) ? this.getHudson() : this.getHudson().getNode(nodeName);
        if (node != null) {
            this.security.checkPermission((AccessControlled)node, Permission.READ);
        }
        return node;
    }

    @Override
    public Node getMasterNode() {
        Hudson masterNode = this.getHudson();
        this.security.checkPermission((AccessControlled)masterNode, Permission.READ);
        return masterNode;
    }

    @Override
    public List<Node> getAllNodes() {
        List<Node> nodesToReturn = this.getNodes();
        Hudson masterNode = this.getHudson();
        if (this.security.hasPermission((AccessControlled)masterNode, Permission.READ)) {
            nodesToReturn.add((Node)masterNode);
        }
        return nodesToReturn;
    }

    @Override
    public List<Node> getNodes() {
        List nodesToCheck = this.getHudson().getNodes();
        ArrayList<Node> nodesToReturn = new ArrayList<Node>(nodesToCheck.size());
        for (Node node : nodesToCheck) {
            if (!this.security.hasPermission((AccessControlled)node, Permission.READ)) continue;
            nodesToReturn.add(node);
        }
        return nodesToReturn;
    }

    @Override
    public Node getCurrentNode() {
        Node node = Computer.currentComputer().getNode();
        this.security.checkPermission((AccessControlled)node, Permission.READ);
        return node;
    }
}

