/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.service.internal;

import com.google.common.base.Preconditions;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.security.AccessControlled;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.service.ProjectNotFoundException;
import org.hudsonci.service.ProjectService;
import org.hudsonci.service.SecurityService;
import org.hudsonci.service.ServiceRuntimeException;
import org.hudsonci.service.SystemIntegrityViolationException;
import org.hudsonci.service.internal.ServicePreconditions;
import org.hudsonci.service.internal.ServiceSupport;
import org.hudsonci.utils.tasks.JobUuid;

@Named
@Singleton
public class ProjectServiceImpl
extends ServiceSupport
implements ProjectService {
    private final SecurityService securityService;

    @Inject
    ProjectServiceImpl(SecurityService securityService) {
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
    }

    @Override
    public AbstractProject<?, ?> getProject(UUID id) {
        AbstractProject<?, ?> project = this.findProject(id);
        if (project == null) {
            throw new ProjectNotFoundException(String.format("No project with UUID '%s' found.", id));
        }
        return project;
    }

    @Override
    public AbstractProject<?, ?> getProject(String projectName) {
        AbstractProject<?, ?> project = this.findProject(projectName);
        if (project == null) {
            throw new ProjectNotFoundException(String.format("Project %s not found.", projectName));
        }
        return project;
    }

    @Override
    public AbstractProject<?, ?> getProjectByFullName(String projectName) {
        AbstractProject<?, ?> p = this.findProjectByFullName(projectName);
        if (p == null) {
            throw new ProjectNotFoundException(String.format("Project %s not found.", projectName));
        }
        return p;
    }

    @Override
    public AbstractProject<?, ?> findProject(UUID id) {
        ServicePreconditions.checkNotNull(id, UUID.class);
        Job job = JobUuid.find((UUID)id);
        return (AbstractProject)job;
    }

    @Override
    public AbstractProject<?, ?> findProject(String projectName) {
        ServicePreconditions.checkProjectName(projectName);
        String[] parts = projectName.split("/", 2);
        if (parts.length == 2) {
            this.log.debug("Detected matrix name: {}", (Object)projectName);
            AbstractProject<?, ?> parent = this.findProject(parts[0]);
            if (parent instanceof MatrixProject) {
                for (MatrixConfiguration config : ((MatrixProject)parent).getItems()) {
                    if (!parts[1].equals(config.getName())) continue;
                    this.log.debug("Selected matrix configuration: {}", (Object)config);
                    return config;
                }
            }
        }
        if (!this.getProjectNames().contains(projectName)) {
            this.log.debug("Project {} not in the list of job names.", (Object)projectName);
            return null;
        }
        AbstractProject<?, ?> project = this.getProjectByFullName(projectName);
        this.log.debug("Selected project: {}", project);
        return project;
    }

    @Override
    public AbstractProject<?, ?> findProjectByFullName(String projectName) {
        ServicePreconditions.checkProjectName(projectName);
        AbstractProject p = (AbstractProject)this.getHudson().getItemByFullName(projectName, AbstractProject.class);
        if (p != null) {
            this.securityService.checkPermission((AccessControlled)p, Item.READ);
        }
        return p;
    }

    @Override
    public List<AbstractProject> getAllProjects() {
        return this.getHudson().getAllItems(AbstractProject.class);
    }

    @Override
    public <T extends AbstractProject<?, ?>> T copyProject(T src, String targetProjectName) throws ServiceRuntimeException {
        ServicePreconditions.checkNotNull(src, AbstractProject.class);
        ServicePreconditions.checkProjectName(targetProjectName);
        this.securityService.checkPermission(Item.CREATE);
        this.securityService.checkPermission((AccessControlled)src, Item.EXTENDED_READ);
        if (this.projectExists(targetProjectName)) {
            throw new SystemIntegrityViolationException(String.format("Project %s already exists.", targetProjectName));
        }
        try {
            return (T)this.getHudson().copy(src, targetProjectName);
        }
        catch (IOException ex) {
            throw new ServiceRuntimeException(String.format("Project copy failed from %s to %s", src.getName(), targetProjectName), ex);
        }
    }

    @Override
    public TopLevelItem createProjectFromXML(String projectName, InputStream xml) {
        ServicePreconditions.checkProjectName(projectName);
        ServicePreconditions.checkNotNull(xml, InputStream.class);
        this.securityService.checkPermission(Item.CREATE);
        if (this.projectExists(projectName)) {
            throw new SystemIntegrityViolationException(String.format("Project %s already exists.", projectName));
        }
        try {
            return this.getHudson().createProjectFromXML(projectName, xml);
        }
        catch (IOException ex) {
            throw new ServiceRuntimeException(String.format("Project creation failed for %s", projectName), ex);
        }
    }

    @Override
    public boolean projectExists(String projectName) {
        ServicePreconditions.checkProjectName(projectName);
        return this.getProjectNames().contains(projectName);
    }

    @Override
    public Collection<String> getProjectNames() {
        return this.getHudson().getJobNames();
    }
}

