/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.service.internal;

import com.google.common.base.Preconditions;
import hudson.model.Hudson;
import hudson.remoting.VirtualChannel;
import hudson.util.RemotingDiagnostics;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.service.ScriptService;
import org.hudsonci.service.SecurityService;
import org.hudsonci.service.internal.ServiceSupport;

@Named
@Singleton
public class ScriptServiceImpl
extends ServiceSupport
implements ScriptService {
    private final SecurityService security;

    @Inject
    public ScriptServiceImpl(SecurityService security) {
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
    }

    @Override
    public String execute(String script) throws Exception {
        Preconditions.checkNotNull((Object)script);
        this.security.checkPermission(Hudson.ADMINISTER);
        this.log.debug("Executing script on master: {}", (Object)script);
        return RemotingDiagnostics.executeScript((String)script, (VirtualChannel)Hudson.MasterComputer.localChannel);
    }
}

