/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.service.internal;

import com.google.common.base.Preconditions;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.service.SecurityService;
import org.hudsonci.service.internal.ServiceSupport;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Named
@Singleton
public class SecurityServiceImpl
extends ServiceSupport
implements SecurityService {
    @Inject
    SecurityServiceImpl() {
    }

    @Override
    public void checkPermission(Permission permission) {
        this.getHudson().checkPermission(permission);
    }

    @Override
    public User getCurrentUser() {
        return User.current();
    }

    @Override
    public User getUser(String id) {
        return this.getHudson().getUser(id);
    }

    @Override
    public User getUnknownUser() {
        return User.getUnknown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAs(Authentication auth, Runnable task) {
        Preconditions.checkNotNull((Object)auth);
        Preconditions.checkNotNull((Object)task);
        SecurityContext ctx = SecurityContextHolder.getContext();
        Authentication current = ctx.getAuthentication();
        ctx.setAuthentication(auth);
        try {
            task.run();
        }
        finally {
            ctx.setAuthentication(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T callAs(Authentication auth, Callable<T> task) throws Exception {
        Preconditions.checkNotNull((Object)auth);
        Preconditions.checkNotNull(task);
        SecurityContext ctx = SecurityContextHolder.getContext();
        Authentication current = ctx.getAuthentication();
        ctx.setAuthentication(auth);
        try {
            T t = task.call();
            return t;
        }
        finally {
            ctx.setAuthentication(current);
        }
    }

    @Override
    public <T> T callAs2(Authentication auth, Callable<T> task) {
        try {
            return this.callAs(auth, task);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkPermission(AccessControlled controlled, Permission permission) {
        Preconditions.checkNotNull((Object)controlled);
        Preconditions.checkNotNull((Object)permission);
        controlled.checkPermission(permission);
    }

    @Override
    public boolean hasPermission(AccessControlled controlled, Permission permission) {
        Preconditions.checkNotNull((Object)controlled);
        Preconditions.checkNotNull((Object)permission);
        return controlled.hasPermission(permission);
    }
}

