/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.service.internal;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServicePreconditions {
    protected static final Logger log = LoggerFactory.getLogger(ServicePreconditions.class);

    protected ServicePreconditions() {
    }

    public static int checkBuildNumber(int buildNumber) {
        Preconditions.checkArgument((buildNumber > 0 ? 1 : 0) != 0, (String)"buildNumber (%s) must be greater than zero.", (Object[])new Object[]{buildNumber});
        return buildNumber;
    }

    public static int checkBuildStateIndex(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"build state index (%s) must be greater than zero.", (Object[])new Object[]{index});
        return index;
    }

    public static int checkBuilderIndex(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"builder index (%s) must be greater than zero.", (Object[])new Object[]{index});
        return index;
    }

    public static String checkProjectName(String projectName) {
        return ServicePreconditions.checkNotNull(projectName, "project name");
    }

    public static String checkNodeName(String nodeName) {
        return ServicePreconditions.checkNotNull(nodeName, "node name");
    }

    public static String checkDocumentId(String id) {
        ServicePreconditions.checkNotNull(id, "Document ID");
        ServicePreconditions.checkUUID(id);
        return id;
    }

    public static String checkUUID(String uuid) {
        UUID.fromString(uuid);
        return uuid;
    }

    public static <T> T checkNotNull(T reference, String msgKey) {
        return (T)Preconditions.checkNotNull(reference, (String)"%s must not be null.", (Object[])new Object[]{msgKey});
    }

    public static <T> T checkNotNull(T reference, Class<T> clazz) {
        if (reference == null) {
            String msg = clazz == null ? "Required value" : clazz.getName() + " must not be null.";
            throw new NullPointerException(msg);
        }
        return reference;
    }
}

