/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.service.internal;

import com.google.common.base.Preconditions;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.model.Hudson;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.service.SecurityService;
import org.hudsonci.service.ServiceRuntimeException;
import org.hudsonci.service.SystemService;
import org.hudsonci.service.internal.ServiceSupport;
import org.hudsonci.utils.io.FileUtil;

@Named
@Singleton
public class SystemServiceImpl
extends ServiceSupport
implements SystemService {
    private final SecurityService securityService;

    @Inject
    SystemServiceImpl(SecurityService securityService) {
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
    }

    @Override
    public File getInstallationDirectory() {
        File dir;
        try {
            ProtectionDomain pd = Hudson.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            URL url = cs.getLocation();
            String path = url.getPath();
            dir = new File(path);
            dir = dir.getParentFile().getParentFile();
            dir = FileUtil.canonicalize((File)dir);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Could not reliably determine the installation directory", e);
        }
        return dir;
    }

    @Override
    public File getLogDirectory() {
        File file = new File(this.getInstallationDirectory(), "var/log");
        file = FileUtil.canonicalize((File)file);
        return file;
    }

    @Override
    public File getWorkingDirectory() {
        return this.getHudson().getRootDir();
    }

    @Override
    public XmlFile getConfigFile() {
        this.securityService.checkPermission(Hudson.ADMINISTER);
        File f = new File(this.getWorkingDirectory(), "config.xml");
        return new XmlFile(Hudson.XSTREAM, f);
    }

    @Override
    public String getUrl() {
        String url = this.getHudson().getRootUrl();
        if (url == null) {
            this.log.warn("Underlying Hudson root url is null; using DEFAULT_URL");
            url = "http://localhost:8082";
        } else if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    @Override
    public String getVersion() {
        return Hudson.getVersion().toString();
    }

    @Override
    public InitMilestone getInitLevel() {
        return this.getHudson().getInitLevel();
    }

    @Override
    public boolean isQuietingDown() {
        return this.getHudson().isQuietingDown();
    }

    @Override
    public boolean isTerminating() {
        return this.getHudson().isTerminating();
    }

    @Override
    public String getSystemMessage() {
        return this.getHudson().getSystemMessage();
    }

    @Override
    public void doQuietDown() {
        try {
            this.getHudson().doQuietDown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void doQuietDown(boolean toggle) {
        if (toggle) {
            this.log.debug("Quieting down");
            this.doQuietDown();
        } else {
            this.log.debug("Canceling quiet down");
            this.doCancelQuietDown();
        }
    }

    @Override
    public void doCancelQuietDown() {
        this.getHudson().doCancelQuietDown();
    }

    @Override
    public void doReload() {
        this.log.debug("Reloading configuration");
        try {
            this.getHudson().doReload();
        }
        catch (IOException ex) {
            throw new ServiceRuntimeException("Could not reload.", ex);
        }
    }

    @Override
    public void doRestart(boolean safely) {
        try {
            if (safely) {
                this.log.debug("Restarting (safely)");
                this.getHudson().safeRestart();
            } else {
                this.log.debug("Restarting");
                this.getHudson().restart();
            }
        }
        catch (RestartNotSupportedException ex) {
            throw new ServiceRuntimeException("Restart not supported", ex);
        }
    }

    @Override
    public void doRestart() {
        this.log.debug("Restarting");
        try {
            this.getHudson().safeRestart();
        }
        catch (RestartNotSupportedException ex) {
            throw new ServiceRuntimeException("Restart not supported", ex);
        }
    }

    @Override
    public void doRestartSafely() {
        this.log.debug("Restarting (safely)");
        try {
            this.getHudson().restart();
        }
        catch (RestartNotSupportedException ex) {
            throw new ServiceRuntimeException("Restart not supported", ex);
        }
    }
}

