/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.servlets.internal;

import com.google.common.base.Preconditions;
import hudson.util.PluginServletFilter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import org.hudsonci.servlets.ServletContainer;
import org.hudsonci.servlets.ServletContainerAware;
import org.hudsonci.servlets.ServletRegistration;
import org.hudsonci.servlets.internal.ServletRegistrationFilterAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class ServletContainerImpl
implements ServletContainer {
    private static final Logger log = LoggerFactory.getLogger(ServletContainerImpl.class);
    private final Map<ServletRegistration, Filter> registrations = new LinkedHashMap<ServletRegistration, Filter>();
    private final List<ServletContainerAware> concerned;

    @Inject
    public ServletContainerImpl(List<ServletContainerAware> concerned) {
        this.concerned = (List)Preconditions.checkNotNull(concerned);
    }

    private ServletContainerAware[] getConcerned() {
        return this.concerned.toArray(new ServletContainerAware[this.concerned.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        log.debug("Starting");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServletContainerAware target : this.getConcerned()) {
            Thread.currentThread().setContextClassLoader(target.getClass().getClassLoader());
            try {
                target.setServletContainer(this);
            }
            catch (Exception e) {
                log.error("Exception while exposing servlet container to: " + target, (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        log.debug("Stopping");
        for (Filter filter : this.registrations.values()) {
            PluginServletFilter.removeFilter((Filter)filter);
        }
        this.registrations.clear();
    }

    @Override
    public ServletRegistration.Handle register(ServletRegistration registration) throws Exception {
        Preconditions.checkNotNull((Object)registration);
        log.debug("Registering: {}", (Object)registration);
        registration = registration.clone();
        ServletRegistrationFilterAdapter filter = new ServletRegistrationFilterAdapter(registration);
        PluginServletFilter.addFilter((Filter)filter);
        this.registrations.put(registration, filter);
        return new HandleImpl(registration, filter);
    }

    private class HandleImpl
    implements ServletRegistration.Handle {
        private final ServletRegistration registration;
        private final ServletRegistrationFilterAdapter filterAdapter;

        private HandleImpl(ServletRegistration registration, ServletRegistrationFilterAdapter filterAdapter) {
            this.registration = (ServletRegistration)Preconditions.checkNotNull((Object)registration);
            this.filterAdapter = (ServletRegistrationFilterAdapter)Preconditions.checkNotNull((Object)filterAdapter);
        }

        @Override
        public ServletRegistration getRegistration() {
            return this.registration;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.filterAdapter.setEnabled(enabled);
        }

        @Override
        public boolean isEnabled() {
            return this.filterAdapter.isEnabled();
        }
    }
}

