/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.servlets.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.hudsonci.servlets.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRegistrationFilterAdapter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ServletRegistrationFilterAdapter.class);
    private final ServletRegistration registration;
    private final Servlet servlet;
    private final String uriPrefix;
    private boolean enabled;

    public ServletRegistrationFilterAdapter(ServletRegistration registration) throws Exception {
        this.registration = (ServletRegistration)Preconditions.checkNotNull((Object)registration);
        this.servlet = this.createServlet();
        if (registration.getName() == null) {
            registration.setName(this.servlet.getClass().getName());
        }
        this.uriPrefix = registration.getUriPrefix();
        if (this.uriPrefix == null) {
            throw new IllegalArgumentException("Registration missing uriPrefix");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private Servlet createServlet() throws Exception {
        Servlet servlet = this.registration.getServlet();
        if (servlet != null) {
            return servlet;
        }
        Class<? extends Servlet> type = this.registration.getServletType();
        if (type != null) {
            return type.newInstance();
        }
        throw new IllegalArgumentException("Registration missing servlet or servlet type");
    }

    public void init(final FilterConfig config) throws ServletException {
        Preconditions.checkNotNull((Object)config);
        this.servlet.init(new ServletConfig(){

            public String getServletName() {
                return ServletRegistrationFilterAdapter.this.registration.getName();
            }

            public ServletContext getServletContext() {
                return config.getServletContext();
            }

            public Enumeration getInitParameterNames() {
                final Iterator<String> iter = ServletRegistrationFilterAdapter.this.registration.getParameters().keySet().iterator();
                return new Enumeration(){

                    @Override
                    public boolean hasMoreElements() {
                        return iter.hasNext();
                    }

                    public Object nextElement() {
                        return iter.next();
                    }
                };
            }

            public String getInitParameter(String name) {
                return ServletRegistrationFilterAdapter.this.registration.getParameters().get(name);
            }
        });
    }

    public void destroy() {
        this.servlet.destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        assert (chain != null);
        if (this.isEnabled() && request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        assert (request != null);
        assert (response != null);
        assert (chain != null);
        String contextPath = request.getContextPath();
        if (!contextPath.endsWith("/") && !this.uriPrefix.startsWith("/")) {
            contextPath = contextPath + '/';
        }
        if (request.getRequestURI().startsWith(contextPath + this.uriPrefix)) {
            HttpServletRequestWrapper req = new HttpServletRequestWrapper(request){

                public String getServletPath() {
                    return String.format("/%s", ServletRegistrationFilterAdapter.this.uriPrefix);
                }
            };
            this.servlet.service((ServletRequest)req, (ServletResponse)response);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

