/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.LinkOption;
import java.util.Locale;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.providers.ScanningAppProvider;
import org.eclipse.jetty.deploy.util.FileID;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Provider for start-up deployement of webapps based on presence in directory")
public class WebAppProvider
extends ScanningAppProvider {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppProvider.class);
    private boolean _extractWars = false;
    private boolean _parentLoaderPriority = false;
    private ConfigurationManager _configurationManager;
    private String _defaultsDescriptor;
    private File _tempDirectory;
    private String[] _configurationClasses;

    public WebAppProvider() {
        this.setFilenameFilter(new Filter());
        this.setScanInterval(0);
    }

    @ManagedAttribute(value="extract war files")
    public boolean isExtractWars() {
        return this._extractWars;
    }

    public void setExtractWars(boolean extractWars) {
        this._extractWars = extractWars;
    }

    @ManagedAttribute(value="parent classloader has priority")
    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._parentLoaderPriority = parentLoaderPriority;
    }

    @ManagedAttribute(value="default descriptor for webapps")
    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configurationManager;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.updateBean(this._configurationManager, configurationManager);
        this._configurationManager = configurationManager;
    }

    public void setConfigurationClasses(String[] configurations) {
        this._configurationClasses = configurations == null ? null : (String[])configurations.clone();
    }

    @ManagedAttribute(value="configuration classes for webapps to be processed through")
    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public void setTempDir(File directory) {
        this._tempDirectory = directory;
    }

    @ManagedAttribute(value="temp directory for use, null if no user set temp directory")
    public File getTempDir() {
        return this._tempDirectory;
    }

    protected void initializeWebAppContextDefaults(WebAppContext webapp) {
        if (this._defaultsDescriptor != null) {
            webapp.setDefaultsDescriptor(this._defaultsDescriptor);
        }
        webapp.setExtractWAR(this._extractWars);
        webapp.setParentLoaderPriority(this._parentLoaderPriority);
        if (this._configurationClasses != null) {
            webapp.setConfigurationClasses(this._configurationClasses);
        }
        if (this._tempDirectory != null) {
            webapp.setAttribute("org.eclipse.jetty.webapp.basetempdir", (Object)this._tempDirectory);
        }
    }

    @Override
    public ContextHandler createContextHandler(App app) throws Exception {
        Resource resource = Resource.newResource((String)app.getOriginId());
        File file = resource.getFile();
        if (!resource.exists()) {
            throw new IllegalStateException("App resource does not exist " + resource);
        }
        final String contextName = file.getName();
        if (resource.isAlias() && !(resource = Resource.newResource((File)(file = new File(resource.getAlias()).toPath().toRealPath(new LinkOption[0]).toFile()))).exists()) {
            throw new IllegalStateException("App resource does not exist " + resource);
        }
        if (resource.exists() && FileID.isXmlFile(file)) {
            XmlConfiguration xmlc = new XmlConfiguration(resource){

                public void initializeDefaults(Object context) {
                    super.initializeDefaults(context);
                    if (context instanceof ContextHandler) {
                        WebAppProvider.this.initializeContextPath((ContextHandler)context, contextName, true);
                    }
                    if (context instanceof WebAppContext) {
                        WebAppProvider.this.initializeWebAppContextDefaults((WebAppContext)context);
                    }
                }
            };
            this.getDeploymentManager().scope(xmlc, resource);
            if (this.getConfigurationManager() != null) {
                xmlc.getProperties().putAll(this.getConfigurationManager().getProperties());
            }
            return (ContextHandler)xmlc.configure();
        }
        if (!file.isDirectory() && !FileID.isWebArchiveFile(file)) {
            throw new IllegalStateException("unable to create ContextHandler for " + app);
        }
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setWar(file.getAbsolutePath());
        this.initializeContextPath((ContextHandler)webAppContext, contextName, !file.isDirectory());
        this.initializeWebAppContextDefaults(webAppContext);
        return webAppContext;
    }

    protected void initializeContextPath(ContextHandler context, String contextName, boolean stripExtension) {
        Object contextPath = contextName;
        if (stripExtension && ((String)contextPath).length() > 4 && ((String)contextPath).charAt(((String)contextPath).length() - 4) == '.') {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 4);
        }
        if (((String)contextPath).endsWith("/") && ((String)contextPath).length() > 1) {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
        }
        if (((String)contextPath).equalsIgnoreCase("root")) {
            contextPath = "/";
        } else if (StringUtil.startsWithIgnoreCase((String)contextPath, (String)"root-")) {
            int dash = ((String)contextPath).indexOf(45);
            String virtual = ((String)contextPath).substring(dash + 1);
            context.setVirtualHosts(virtual.split(","));
            contextPath = "/";
        }
        if (((String)contextPath).charAt(0) != '/') {
            contextPath = "/" + (String)contextPath;
        }
        context.setDisplayName(contextName);
        if (context instanceof WebAppContext) {
            WebAppContext webAppContext = (WebAppContext)context;
            webAppContext.setDefaultContextPath((String)contextPath);
        } else {
            context.setContextPath((String)contextPath);
        }
    }

    @Override
    protected void fileChanged(String filename) throws Exception {
        File file = new File(filename);
        if (!file.exists()) {
            return;
        }
        File parent = file.getParentFile();
        if (file.isDirectory()) {
            if (this.exists(file.getName() + ".xml") || this.exists(file.getName() + ".XML")) {
                return;
            }
            if (this.exists(file.getName() + ".war") || this.exists(file.getName() + ".WAR")) {
                return;
            }
            super.fileChanged(filename);
            return;
        }
        String lowname = file.getName().toLowerCase(Locale.ENGLISH);
        if (lowname.endsWith(".war")) {
            String name = file.getName();
            String base = name.substring(0, name.length() - 4);
            String xmlname = base + ".xml";
            if (this.exists(xmlname)) {
                File xml = new File(parent, xmlname);
                super.fileChanged(xml.getPath());
                return;
            }
            xmlname = base + ".XML";
            if (this.exists(xmlname)) {
                File xml = new File(parent, xmlname);
                super.fileChanged(xml.getPath());
                return;
            }
            super.fileChanged(filename);
            return;
        }
        if (lowname.endsWith(".xml")) {
            super.fileChanged(filename);
        }
    }

    @Override
    protected void fileAdded(String filename) throws Exception {
        File file = new File(filename);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            if (this.exists(file.getName() + ".xml") || this.exists(file.getName() + ".XML")) {
                return;
            }
            if (this.exists(file.getName() + ".war") || this.exists(file.getName() + ".WAR")) {
                return;
            }
            super.fileAdded(filename);
            return;
        }
        String lowname = file.getName().toLowerCase(Locale.ENGLISH);
        if (lowname.endsWith(".war")) {
            String name = file.getName();
            String base = name.substring(0, name.length() - 4);
            if (this.exists(base + ".xml") || this.exists(base + ".XML")) {
                return;
            }
            super.fileAdded(filename);
            return;
        }
        if (lowname.endsWith(".xml")) {
            super.fileAdded(filename);
        }
    }

    @Override
    protected void fileRemoved(String filename) throws Exception {
        File file = new File(filename);
        String lowname = file.getName().toLowerCase(Locale.ENGLISH);
        if (lowname.endsWith(".war")) {
            String name = file.getName();
            String base = name.substring(0, name.length() - 4);
            if (this.exists(base + ".xml") || this.exists(base + ".XML")) {
                return;
            }
            super.fileRemoved(filename);
            return;
        }
        if (lowname.endsWith(".xml")) {
            super.fileRemoved(filename);
            return;
        }
        if (this.exists(file.getName() + ".xml") || this.exists(file.getName() + ".XML")) {
            return;
        }
        if (this.exists(file.getName() + ".war") || this.exists(file.getName() + ".WAR")) {
            return;
        }
        super.fileRemoved(filename);
    }

    public class Filter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            if (dir == null || !dir.canRead()) {
                return false;
            }
            String lowerName = name.toLowerCase(Locale.ENGLISH);
            Resource resource = Resource.newResource((File)new File(dir, name));
            if (WebAppProvider.this.getMonitoredResources().stream().anyMatch(arg_0 -> ((Resource)resource).isSame(arg_0))) {
                return false;
            }
            if (lowerName.startsWith(".")) {
                return false;
            }
            if (resource.isDirectory()) {
                if (lowerName.endsWith(".d")) {
                    return false;
                }
                if (WebAppProvider.this.exists(name + ".war") || WebAppProvider.this.exists(name + ".WAR")) {
                    return false;
                }
                if (WebAppProvider.this.exists(name + ".xml") || WebAppProvider.this.exists(name + ".XML")) {
                    return false;
                }
                return !"cvs".equals(lowerName) && !"cvsroot".equals(lowerName);
            }
            if (lowerName.endsWith(".war")) {
                return true;
            }
            return lowerName.endsWith(".xml");
        }
    }
}

