/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.git;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.toolchain.version.git.GitCommit;
import org.eclipse.jetty.toolchain.version.git.GitOutputParser;
import org.eclipse.jetty.toolchain.version.issues.Issue;
import org.eclipse.jetty.toolchain.version.issues.IssueParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitLogParser
implements GitOutputParser {
    private static final String AUTHOR_DATE = "#AUTHOR_DATE#:";
    private static final String AUTHOR_NAME = "#AUTHOR_NAME#:";
    private static final String BODY = "#BODY#:";
    private static final String COMMIT_ID = "#COMMIT_ID#:";
    private static final String COMMITTER_DATE = "#COMMITTER_DATE#:";
    private static final String COMMITTER_NAME = "#COMMITTER_NAME#:";
    private static final String END = "####";
    private static final String SUBJECT = "#SUBJECT#:";
    private GitCommit activeCommit;
    private final List<GitCommit> commits = new ArrayList<GitCommit>();

    public String getFormat() {
        StringBuilder fmt = new StringBuilder();
        fmt.append("--pretty=format:");
        fmt.append(COMMIT_ID).append("%H%n");
        fmt.append(AUTHOR_NAME).append("%an%n");
        fmt.append(AUTHOR_DATE).append("%ai%n");
        fmt.append(COMMITTER_NAME).append("%cn%n");
        fmt.append(COMMITTER_DATE).append("%ci%n");
        fmt.append(SUBJECT).append("%s%n");
        fmt.append(BODY).append("%b%n");
        fmt.append(END);
        return fmt.toString();
    }

    public GitCommit getGitCommitLog(int index) {
        return this.commits.get(index);
    }

    public List<GitCommit> getGitCommitLogs() {
        return this.commits;
    }

    public List<Issue> getIssues() {
        IssueParser issueparser = new IssueParser();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (GitCommit commit : this.commits) {
            Issue issue = issueparser.parsePossibleIssue(commit.getSubject());
            if (issue == null) continue;
            issues.add(issue);
        }
        return issues;
    }

    @Override
    public void parseEnd() {
        if (this.activeCommit != null) {
            this.commits.add(this.activeCommit);
        }
    }

    @Override
    public void parseLine(int linenum, String line) throws ParseException {
        if (this.activeCommit == null) {
            this.activeCommit = new GitCommit();
        }
        if (line.startsWith(COMMIT_ID)) {
            this.activeCommit.setCommitId(line.substring(COMMIT_ID.length()));
        } else if (line.startsWith(AUTHOR_NAME)) {
            this.activeCommit.setAuthorName(line.substring(AUTHOR_NAME.length()));
        } else if (line.startsWith(AUTHOR_DATE)) {
            this.activeCommit.parseAuthorDate(line.substring(AUTHOR_DATE.length()));
        } else if (line.startsWith(COMMITTER_NAME)) {
            this.activeCommit.setCommitterName(line.substring(COMMITTER_NAME.length()));
        } else if (line.startsWith(COMMITTER_DATE)) {
            this.activeCommit.parseCommitterDate(line.substring(COMMITTER_DATE.length()));
        } else if (line.startsWith(SUBJECT)) {
            this.activeCommit.setSubject(line.substring(SUBJECT.length()));
        } else if (line.startsWith(BODY)) {
            this.activeCommit.setBody(line.substring(BODY.length()));
        } else if (line.equals(END)) {
            this.commits.add(this.activeCommit);
            this.activeCommit = null;
        } else {
            this.activeCommit.appendBody(line.trim());
        }
    }

    @Override
    public void parseStart() {
        this.commits.clear();
    }
}

