/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import com.google.gson.JsonObject;
import org.eclipse.jkube.kit.common.JsonFactory;

public class ImagePullCache {
    private static final String CONTEXT_KEY_PREVIOUSLY_PULLED = "CONTEXT_KEY_PREVIOUSLY_PULLED";
    private final Backend backend;

    public ImagePullCache(Backend backend) {
        this.backend = backend;
    }

    public boolean hasAlreadyPulled(String image) {
        return this.load().has(image);
    }

    public void pulled(String image) {
        this.save(this.load().add(image));
    }

    private ImagePullCacheStore load() {
        String pullCacheJson = this.backend.get(CONTEXT_KEY_PREVIOUSLY_PULLED);
        ImagePullCacheStore cache = new ImagePullCacheStore(pullCacheJson);
        if (pullCacheJson == null) {
            this.save(cache);
        }
        return cache;
    }

    private void save(ImagePullCacheStore cache) {
        this.backend.put(CONTEXT_KEY_PREVIOUSLY_PULLED, cache.toString());
    }

    class ImagePullCacheStore {
        private JsonObject cache;

        ImagePullCacheStore(String json) {
            this.cache = json != null ? JsonFactory.newJsonObject((String)json) : new JsonObject();
        }

        public boolean has(String imageName) {
            return this.cache.has(imageName);
        }

        public ImagePullCacheStore add(String image) {
            this.cache.addProperty(image, Boolean.TRUE);
            return this;
        }

        public String toString() {
            return this.cache.toString();
        }
    }

    public static interface Backend {
        public String get(String var1);

        public void put(String var1, String var2);
    }
}

