/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteIU;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.tycho.p2.impl.publisher.AbstractDependenciesAction;

public abstract class AbstractSiteDependenciesAction
extends AbstractDependenciesAction {
    private final String id;
    private final String version;

    public AbstractSiteDependenciesAction(String id, String version) {
        this.id = id;
        this.version = version;
    }

    abstract SiteModel getSiteModel();

    @Override
    protected Set<IRequirement> getRequiredCapabilities() {
        VersionRange range;
        String id;
        LinkedHashSet<IRequirement> required = new LinkedHashSet<IRequirement>();
        SiteFeature[] siteFeatureArray = this.getSiteModel().getFeatures();
        int n = siteFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            SiteFeature feature = siteFeatureArray[n2];
            id = String.valueOf(feature.getFeatureIdentifier()) + ".feature.group";
            range = this.getVersionRange(this.createVersion(feature.getFeatureVersion()));
            required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, null, (boolean)false, (boolean)false));
            ++n2;
        }
        siteFeatureArray = this.getSiteModel().getBundles();
        n = siteFeatureArray.length;
        n2 = 0;
        while (n2 < n) {
            SiteFeature bundle = siteFeatureArray[n2];
            id = bundle.getBundleIdentifier();
            range = this.getVersionRange(this.createVersion(bundle.getBundleVersion()));
            required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, null, (boolean)false, (boolean)false));
            ++n2;
        }
        siteFeatureArray = this.getSiteModel().getIUs();
        n = siteFeatureArray.length;
        n2 = 0;
        while (n2 < n) {
            SiteFeature iu = siteFeatureArray[n2];
            IRequirement requirement = this.getRequirement((SiteIU)iu);
            if (requirement != null) {
                required.add(requirement);
            }
            ++n2;
        }
        return required;
    }

    private IRequirement getRequirement(SiteIU iu) {
        String id = iu.getID();
        String range = iu.getRange();
        String type = iu.getQueryType();
        String expression = iu.getQueryExpression();
        Object[] params = iu.getQueryParams();
        if (id != null) {
            VersionRange vRange = new VersionRange(range);
            return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)vRange, null, (boolean)false, (boolean)false);
        }
        if ("match".equals(type)) {
            IMatchExpression iuMatcher = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)expression), params);
            return MetadataFactory.createRequirement((IMatchExpression)iuMatcher, null, (int)0, (int)1, (boolean)true);
        }
        if ("context".equals(type)) {
            throw new IllegalStateException("Context iu queries are not supported in Tycho. Faulty expression is " + expression);
        }
        return null;
    }

    @Override
    protected String getId() {
        return this.id;
    }

    @Override
    protected Version getVersion() {
        return AbstractSiteDependenciesAction.createSiteVersion(this.version);
    }

    public static Version createSiteVersion(String version) {
        try {
            return Version.create((String)version);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Version.create((String)("format(n[.n=0;[.n=0;['-'S]]]):" + version));
        }
    }
}

