/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler;

import copied.org.apache.maven.plugin.AbstractCompilerMojo;
import copied.org.apache.maven.plugin.CompilationFailureException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.classpath.JavaCompilerConfiguration;
import org.eclipse.tycho.classpath.SourcepathEntry;
import org.eclipse.tycho.compiler.CopyMapping;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.eclipse.tycho.core.osgitools.DefaultClasspathEntry;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.runtime.Adaptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOsgiCompilerMojo
extends AbstractCompilerMojo
implements JavaCompilerConfiguration,
Adaptable {
    public static final String RULE_SEPARATOR = File.pathSeparator;
    public static final String RULE_EXCLUDE_ALL = "?**/*";
    private static final Set<String> MATCH_ALL = Collections.singleton("**/*");
    private MavenProject project;
    private Dependency[] extraClasspathElements;
    private MavenSession session;
    private RepositorySystem repositorySystem;
    private JDKUsage useJDK;
    private ToolchainManagerPrivate toolChainManager;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private Set<String> excludeResources = new HashSet<String>();
    private boolean requireJREPackageImports;
    private boolean strictCompilerTarget;
    private BuildOutputJar outputJar;
    private Map<String, TychoProject> projectTypes;

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        ExecutionEnvironment minimalBREE = this.getBundleProject().getManifestMinimalEE(this.project);
        this.getLog().debug((CharSequence)("Manifest minimal BREE: " + (minimalBREE != null ? minimalBREE.toString() : "<null>")));
        this.getLog().debug((CharSequence)("Effective EE: " + this.getTargetExecutionEnvironment()));
        String effectiveTargetLevel = this.getTargetLevel();
        this.getLog().debug((CharSequence)("Effective source/target: " + this.getSourceLevel() + "/" + effectiveTargetLevel));
        if (minimalBREE != null && !minimalBREE.isCompatibleCompilerTargetLevel(effectiveTargetLevel)) {
            String message = "Effective compiler target " + effectiveTargetLevel + " is incompatible with " + minimalBREE + " @ " + this.project;
            if (this.strictCompilerTarget) {
                throw new MojoExecutionException(message);
            }
            this.getLog().warn((CharSequence)message);
        }
        Iterator i$ = this.getEclipsePluginProject().getOutputJars().iterator();
        while (i$.hasNext()) {
            BuildOutputJar jar;
            this.outputJar = jar = (BuildOutputJar)i$.next();
            this.outputJar.getOutputDirectory().mkdirs();
            super.execute();
            this.copyResources();
        }
        BuildOutputJar dotOutputJar = this.getEclipsePluginProject().getDotOutputJar();
        if (dotOutputJar != null) {
            this.project.getArtifact().setFile(dotOutputJar.getOutputDirectory());
        }
    }

    private void copyResources() throws MojoExecutionException {
        for (String sourceRoot : this.getCompileSourceRoots()) {
            File sourceRootFile = new File(sourceRoot);
            if (!sourceRootFile.isDirectory()) {
                this.getLog().warn((CharSequence)("Source directory " + sourceRoot + " does not exist"));
                continue;
            }
            HashSet<String> excludes = new HashSet<String>();
            excludes.addAll(this.excludeResources);
            excludes.addAll(this.getEclipsePluginProject().getBuildProperties().getBinExcludes());
            excludes.add("**/*.java");
            StaleSourceScanner scanner = new StaleSourceScanner(0L, MATCH_ALL, excludes);
            CopyMapping copyMapping = new CopyMapping();
            scanner.addSourceMapping((SourceMapping)copyMapping);
            try {
                scanner.getIncludedSources(sourceRootFile, this.outputJar.getOutputDirectory());
                for (CopyMapping.SourceTargetPair sourceTargetPair : copyMapping.getSourceTargetPairs()) {
                    FileUtils.copyFile((File)new File(sourceRoot, sourceTargetPair.source), (File)sourceTargetPair.target);
                }
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Exception while scanning for resource files in " + sourceRoot, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception copying resource files from " + sourceRoot + " to " + this.outputJar.getOutputDirectory(), (Exception)e);
            }
        }
    }

    public EclipsePluginProject getEclipsePluginProject() throws MojoExecutionException {
        return ((OsgiBundleProject)this.getBundleProject()).getEclipsePluginProject(DefaultReactorProject.adapt((MavenProject)this.project));
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputJar.getOutputDirectory();
    }

    @Override
    public List<String> getClasspathElements() throws MojoExecutionException {
        ArrayList<String> classpath = new ArrayList<String>();
        for (ClasspathEntry cpe : this.getClasspath()) {
            for (File location : cpe.getLocations()) {
                classpath.add(location.getAbsolutePath() + this.toString(cpe.getAccessRules()));
            }
        }
        return classpath;
    }

    private BundleProject getBundleProject() throws MojoExecutionException {
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        if (!(projectType instanceof BundleProject)) {
            throw new MojoExecutionException("Not a bundle project " + this.project.toString());
        }
        return (BundleProject)projectType;
    }

    private String toString(List<ClasspathEntry.AccessRule> rules) {
        StringBuilder result = new StringBuilder();
        if (rules != null) {
            result.append("[");
            for (ClasspathEntry.AccessRule rule : rules) {
                if (result.length() > 1) {
                    result.append(RULE_SEPARATOR);
                }
                result.append(rule.isDiscouraged() ? "~" : "+");
                result.append(rule.getPattern());
            }
            if (result.length() > 1) {
                result.append(RULE_SEPARATOR);
            }
            result.append(RULE_EXCLUDE_ALL);
            result.append("]");
        }
        return result.toString();
    }

    @Override
    protected final List<String> getCompileSourceRoots() throws MojoExecutionException {
        ArrayList<String> roots = new ArrayList<String>();
        for (File folder : this.outputJar.getSourceFolders()) {
            roots.add(new File(folder.getAbsoluteFile().toURI().normalize()).toString());
        }
        return roots;
    }

    public List<SourcepathEntry> getSourcepath() throws MojoExecutionException {
        ArrayList<SourcepathEntry> entries = new ArrayList<SourcepathEntry>();
        for (BuildOutputJar jar : this.getEclipsePluginProject().getOutputJars()) {
            final File outputDirectory = jar.getOutputDirectory();
            for (final File sourcesRoot : jar.getSourceFolders()) {
                SourcepathEntry entry = new SourcepathEntry(){

                    public File getSourcesRoot() {
                        return sourcesRoot;
                    }

                    public File getOutputDirectory() {
                        return outputDirectory;
                    }

                    public List<String> getIncludes() {
                        return null;
                    }

                    public List<String> getExcludes() {
                        return null;
                    }
                };
                entries.add(entry);
            }
        }
        return entries;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            this.includes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(this.includes, Collections.EMPTY_SET);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected CompilerConfiguration getCompilerConfiguration(List<String> compileSourceRoots) throws MojoExecutionException {
        CompilerConfiguration compilerConfiguration = super.getCompilerConfiguration(compileSourceRoots);
        String encoding = (String)this.getEclipsePluginProject().getBuildProperties().getJarToJavacDefaultEncodingMap().get(this.outputJar.getName());
        if (encoding != null) {
            compilerConfiguration.setSourceEncoding(encoding);
        }
        this.configureSourceAndTargetLevel(compilerConfiguration);
        this.configureJavaHome(compilerConfiguration);
        this.configureBootclasspathAccessRules(compilerConfiguration);
        return compilerConfiguration;
    }

    private void configureBootclasspathAccessRules(CompilerConfiguration compilerConfiguration) throws MojoExecutionException {
        ArrayList<ClasspathEntry.AccessRule> accessRules = new ArrayList<ClasspathEntry.AccessRule>();
        if (this.requireJREPackageImports) {
            accessRules.addAll(this.getStrictBootClasspathAccessRules());
        } else {
            accessRules.add((ClasspathEntry.AccessRule)new DefaultClasspathEntry.DefaultAccessRule("java/**", false));
            for (String pkg : this.getTargetExecutionEnvironment().getSystemPackages()) {
                accessRules.add((ClasspathEntry.AccessRule)new DefaultClasspathEntry.DefaultAccessRule(pkg.trim().replace('.', '/') + "/*", false));
            }
            accessRules.addAll(this.getBundleProject().getBootClasspathExtraAccessRules(this.project));
        }
        if (accessRules.size() > 0) {
            compilerConfiguration.addCompilerCustomArgument("org.osgi.framework.system.packages", this.toString(accessRules));
        }
    }

    private List<ClasspathEntry.AccessRule> getStrictBootClasspathAccessRules() throws MojoExecutionException {
        return (List)this.project.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_STRICT_BOOTCLASSPATH_ACCESSRULES);
    }

    private void configureJavaHome(CompilerConfiguration compilerConfiguration) throws MojoExecutionException {
        if (this.useJDK != JDKUsage.BREE) {
            return;
        }
        DefaultJavaToolChain toolChain = this.findMatchingJavaToolChain(this.getTargetExecutionEnvironment());
        compilerConfiguration.addCompilerCustomArgument("use.java.home", toolChain.getJavaHome());
        this.configureBootClassPath(compilerConfiguration, toolChain);
    }

    private void configureBootClassPath(CompilerConfiguration compilerConfiguration, DefaultJavaToolChain javaToolChain) {
        Xpp3Dom[] includes;
        Xpp3Dom includeParent;
        Xpp3Dom bootClassPath;
        Xpp3Dom config = (Xpp3Dom)javaToolChain.getModel().getConfiguration();
        if (config != null && (bootClassPath = config.getChild("bootClassPath")) != null && (includeParent = bootClassPath.getChild("includes")) != null && (includes = includeParent.getChildren("include")).length > 0) {
            compilerConfiguration.addCompilerCustomArgument("-bootclasspath", this.scanBootclasspath(javaToolChain.getJavaHome(), includes, bootClassPath.getChild("excludes")));
        }
    }

    private String scanBootclasspath(String javaHome, Xpp3Dom[] includes, Xpp3Dom excludeParent) {
        Xpp3Dom[] excludes;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(javaHome);
        scanner.setIncludes(AbstractOsgiCompilerMojo.getValues(includes));
        if (excludeParent != null && (excludes = excludeParent.getChildren("exclude")).length > 0) {
            scanner.setExcludes(AbstractOsgiCompilerMojo.getValues(excludes));
        }
        scanner.scan();
        StringBuilder bootClassPath = new StringBuilder();
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            if (i > 0) {
                bootClassPath.append(File.pathSeparator);
            }
            bootClassPath.append(new File(javaHome, includedFiles[i]).getAbsolutePath());
        }
        return bootClassPath.toString();
    }

    private static String[] getValues(Xpp3Dom[] doms) {
        String[] values = new String[doms.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = doms[i].getValue();
        }
        return values;
    }

    private DefaultJavaToolChain findMatchingJavaToolChain(ExecutionEnvironment environment) throws MojoExecutionException {
        try {
            Map<String, String> requirements = Collections.singletonMap("id", environment.getProfileName());
            for (ToolchainPrivate javaToolChain : this.toolChainManager.getToolchainsForType("jdk", this.session)) {
                if (!javaToolChain.matchesRequirements(requirements) || !(javaToolChain instanceof DefaultJavaToolChain)) continue;
                return (DefaultJavaToolChain)javaToolChain;
            }
            throw new MojoExecutionException("useJDK = BREE configured, but no toolchain of type 'jdk' with id '" + environment.getProfileName() + "' found. See http://maven.apache.org/guides/mini/guide-using-toolchains.html");
        }
        catch (MisconfiguredToolchainException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void configureSourceAndTargetLevel(CompilerConfiguration compilerConfiguration) throws MojoExecutionException {
        ExecutionEnvironment ee = this.getTargetExecutionEnvironment();
        compilerConfiguration.setSourceVersion(this.getSourceLevel(ee));
        compilerConfiguration.setTargetVersion(this.getTargetLevel(ee));
    }

    private ExecutionEnvironment getTargetExecutionEnvironment() throws MojoExecutionException {
        return TychoProjectUtils.getExecutionEnvironmentConfiguration((MavenProject)this.project).getFullSpecification();
    }

    public List<ClasspathEntry> getClasspath() throws MojoExecutionException {
        BundleProject projectType = this.getBundleProject();
        ArrayList<ClasspathEntry> classpath = new ArrayList<ClasspathEntry>(projectType.getClasspath(this.project));
        if (this.extraClasspathElements != null) {
            ArtifactRepository localRepository = this.session.getLocalRepository();
            List remoteRepositories = this.project.getRemoteArtifactRepositories();
            for (Dependency extraDependency : this.extraClasspathElements) {
                Artifact artifact = this.repositorySystem.createDependencyArtifact(extraDependency);
                ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                request.setArtifact(artifact);
                request.setLocalRepository(localRepository);
                request.setRemoteRepositories(remoteRepositories);
                request.setResolveRoot(true);
                request.setResolveTransitively(true);
                ArtifactResolutionResult result = this.repositorySystem.resolve(request);
                if (result.hasExceptions()) {
                    throw new MojoExecutionException("Could not resolve extra classpath entry", (Exception)result.getExceptions().get(0));
                }
                for (Artifact b : result.getArtifacts()) {
                    MavenProject bProject = null;
                    if (b instanceof ProjectArtifact) {
                        bProject = ((ProjectArtifact)b).getProject();
                    }
                    ArrayList<File> bLocations = new ArrayList<File>();
                    bLocations.add(b.getFile());
                    classpath.add((ClasspathEntry)new DefaultClasspathEntry(DefaultReactorProject.adapt((MavenProject)bProject), null, bLocations, null));
                }
            }
        }
        return classpath;
    }

    public String getExecutionEnvironment() throws MojoExecutionException {
        return this.getTargetExecutionEnvironment().getProfileName();
    }

    public String getSourceLevel() throws MojoExecutionException {
        return this.getSourceLevel(this.getTargetExecutionEnvironment());
    }

    private String getSourceLevel(ExecutionEnvironment ee) throws MojoExecutionException {
        if (this.source != null) {
            return this.source;
        }
        String javacSource = this.getEclipsePluginProject().getBuildProperties().getJavacSource();
        if (javacSource != null) {
            return javacSource;
        }
        String eeSource = ee.getCompilerSourceLevelDefault();
        if (eeSource != null) {
            return eeSource;
        }
        return "1.6";
    }

    public String getTargetLevel() throws MojoExecutionException {
        return this.getTargetLevel(this.getTargetExecutionEnvironment());
    }

    public String getTargetLevel(ExecutionEnvironment ee) throws MojoExecutionException {
        if (this.target != null) {
            return this.target;
        }
        String javacTarget = this.getEclipsePluginProject().getBuildProperties().getJavacTarget();
        if (javacTarget != null) {
            return javacTarget;
        }
        String eeTarget = ee.getCompilerTargetLevelDefault();
        if (eeTarget != null) {
            return eeTarget;
        }
        return "1.6";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(JavaCompilerConfiguration.class)) {
            return adapter.cast((Object)this);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JDKUsage {
        SYSTEM,
        BREE;

    }
}

