/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.customization.Customization;

public abstract class AbstractValueTypeDeserializer<T>
implements JsonbDeserializer<T> {
    private final Class<T> clazz;
    private final Customization customization;

    public AbstractValueTypeDeserializer(Class<T> clazz, Customization customization) {
        this.clazz = clazz;
        this.customization = customization;
    }

    public T deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        Unmarshaller unmarshaller = (Unmarshaller)ctx;
        JsonParser.Event event = ((JsonbParser)parser).getCurrentLevel().getLastEvent();
        if (event == JsonParser.Event.VALUE_NULL) {
            return null;
        }
        String value = parser.getString();
        return this.deserialize(value, unmarshaller, rtType);
    }

    protected T deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        throw new UnsupportedOperationException("Operation not supported in " + this.getClass());
    }

    public Customization getCustomization() {
        return this.customization;
    }

    protected Class<T> getPropertyType() {
        return this.clazz;
    }
}

