/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk.byscroll;

import java.util.Collection;
import org.elasticsearch.action.bulk.byscroll.BulkByScrollResponse;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class BulkIndexByScrollResponseMatcher
extends TypeSafeMatcher<BulkByScrollResponse> {
    private Matcher<Long> createdMatcher = Matchers.equalTo((Object)0L);
    private Matcher<Long> updatedMatcher = Matchers.equalTo((Object)0L);
    private Matcher<Long> deletedMatcher = Matchers.equalTo((Object)0L);
    private Matcher<Integer> batchesMatcher;
    private Matcher<Long> versionConflictsMatcher = Matchers.equalTo((Object)0L);
    private Matcher<Integer> failuresMatcher = Matchers.equalTo((Object)0);
    private Matcher<String> reasonCancelledMatcher = Matchers.nullValue(String.class);
    private Matcher<Collection<? extends BulkIndexByScrollResponseMatcher>> slicesMatcher = Matchers.empty();

    public BulkIndexByScrollResponseMatcher created(Matcher<Long> createdMatcher) {
        this.createdMatcher = createdMatcher;
        return this;
    }

    public BulkIndexByScrollResponseMatcher created(long created) {
        return this.created((Matcher<Long>)Matchers.equalTo((Object)created));
    }

    public BulkIndexByScrollResponseMatcher updated(Matcher<Long> updatedMatcher) {
        this.updatedMatcher = updatedMatcher;
        return this;
    }

    public BulkIndexByScrollResponseMatcher updated(long updated) {
        return this.updated((Matcher<Long>)Matchers.equalTo((Object)updated));
    }

    public BulkIndexByScrollResponseMatcher deleted(Matcher<Long> deletedMatcher) {
        this.deletedMatcher = deletedMatcher;
        return this;
    }

    public BulkIndexByScrollResponseMatcher deleted(long deleted) {
        return this.deleted((Matcher<Long>)Matchers.equalTo((Object)deleted));
    }

    public BulkIndexByScrollResponseMatcher batches(Matcher<Integer> batchesMatcher) {
        this.batchesMatcher = batchesMatcher;
        return this;
    }

    public BulkIndexByScrollResponseMatcher batches(int batches) {
        return this.batches((Matcher<Integer>)Matchers.equalTo((Object)batches));
    }

    public BulkIndexByScrollResponseMatcher batches(int total, int batchSize) {
        return this.batches((total + batchSize - 1) / batchSize);
    }

    public BulkIndexByScrollResponseMatcher versionConflicts(Matcher<Long> versionConflictsMatcher) {
        this.versionConflictsMatcher = versionConflictsMatcher;
        return this;
    }

    public BulkIndexByScrollResponseMatcher versionConflicts(long versionConflicts) {
        return this.versionConflicts((Matcher<Long>)Matchers.equalTo((Object)versionConflicts));
    }

    public BulkIndexByScrollResponseMatcher failures(Matcher<Integer> failuresMatcher) {
        this.failuresMatcher = failuresMatcher;
        return this;
    }

    public BulkIndexByScrollResponseMatcher failures(int failures) {
        return this.failures((Matcher<Integer>)Matchers.equalTo((Object)failures));
    }

    public BulkIndexByScrollResponseMatcher reasonCancelled(Matcher<String> reasonCancelledMatcher) {
        this.reasonCancelledMatcher = reasonCancelledMatcher;
        return this;
    }

    public BulkIndexByScrollResponseMatcher slices(Matcher<Collection<? extends BulkIndexByScrollResponseMatcher>> slicesMatcher) {
        this.slicesMatcher = slicesMatcher;
        return this;
    }

    protected boolean matchesSafely(BulkByScrollResponse item) {
        return this.updatedMatcher.matches((Object)item.getUpdated()) && this.createdMatcher.matches((Object)item.getCreated()) && this.deletedMatcher.matches((Object)item.getDeleted()) && (this.batchesMatcher == null || this.batchesMatcher.matches((Object)item.getBatches())) && this.versionConflictsMatcher.matches((Object)item.getVersionConflicts()) && this.failuresMatcher.matches((Object)item.getBulkFailures().size()) && this.reasonCancelledMatcher.matches((Object)item.getReasonCancelled()) && this.slicesMatcher.matches((Object)item.getStatus().getSliceStatuses());
    }

    public void describeTo(Description description) {
        description.appendText("updated matches ").appendDescriptionOf(this.updatedMatcher);
        description.appendText(" and created matches ").appendDescriptionOf(this.createdMatcher);
        description.appendText(" and deleted matches ").appendDescriptionOf(this.deletedMatcher);
        if (this.batchesMatcher != null) {
            description.appendText(" and batches matches ").appendDescriptionOf(this.batchesMatcher);
        }
        description.appendText(" and versionConflicts matches ").appendDescriptionOf(this.versionConflictsMatcher);
        description.appendText(" and failures size matches ").appendDescriptionOf(this.failuresMatcher);
        description.appendText(" and reason cancelled matches ").appendDescriptionOf(this.reasonCancelledMatcher);
        description.appendText(" and slices matches ").appendDescriptionOf(this.slicesMatcher);
    }
}

