/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;

public class MockSecureSettings
implements SecureSettings {
    private Map<String, SecureString> secureStrings = new HashMap<String, SecureString>();
    private Map<String, byte[]> files = new HashMap<String, byte[]>();
    private Set<String> settingNames = new HashSet<String>();

    public boolean isLoaded() {
        return true;
    }

    public Set<String> getSettingNames() {
        return this.settingNames;
    }

    public SecureString getString(String setting) {
        return this.secureStrings.get(setting);
    }

    public InputStream getFile(String setting) {
        return new ByteArrayInputStream(this.files.get(setting));
    }

    public void setString(String setting, String value) {
        this.secureStrings.put(setting, new SecureString(value.toCharArray()));
        this.settingNames.add(setting);
    }

    public void setFile(String setting, byte[] value) {
        this.files.put(setting, value);
        this.settingNames.add(setting);
    }

    public void close() throws IOException {
    }
}

