/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Map;
import org.elasticsearch.ingest.TemplateService;

public class TestTemplateService
implements TemplateService {
    private boolean compilationException;

    public static TemplateService instance() {
        return new TestTemplateService(false);
    }

    public static TemplateService instance(boolean compilationException) {
        return new TestTemplateService(compilationException);
    }

    private TestTemplateService(boolean compilationException) {
        this.compilationException = compilationException;
    }

    public TemplateService.Template compile(String template) {
        if (this.compilationException) {
            throw new RuntimeException("could not compile script");
        }
        return new MockTemplate(template);
    }

    public static class MockTemplate
    implements TemplateService.Template {
        private final String expected;

        public MockTemplate(String expected) {
            this.expected = expected;
        }

        public String execute(Map<String, Object> model) {
            return this.expected;
        }

        public String getKey() {
            return this.expected;
        }
    }
}

