/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.repositories.ESBlobStoreTestCase;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class ESBlobStoreContainerTestCase
extends ESTestCase {
    public void testWriteRead() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            BlobContainer container = store.blobContainer(new BlobPath());
            byte[] data = ESBlobStoreTestCase.randomBytes(ESBlobStoreContainerTestCase.randomIntBetween(10, ESBlobStoreContainerTestCase.scaledRandomIntBetween(1024, 65536)));
            this.writeBlob(container, "foobar", new BytesArray(data));
            try (InputStream stream = container.readBlob("foobar");){
                BytesRefBuilder target = new BytesRefBuilder();
                while (target.length() < data.length) {
                    byte[] buffer = new byte[ESBlobStoreContainerTestCase.scaledRandomIntBetween(1, data.length - target.length())];
                    int offset = ESBlobStoreContainerTestCase.scaledRandomIntBetween(0, buffer.length - 1);
                    int read = stream.read(buffer, offset, buffer.length - offset);
                    target.append(new BytesRef(buffer, offset, read));
                }
                ESBlobStoreContainerTestCase.assertEquals((long)data.length, (long)target.length());
                ESBlobStoreContainerTestCase.assertArrayEquals((byte[])data, (byte[])Arrays.copyOfRange(target.bytes(), 0, target.length()));
            }
        }
    }

    public void testMoveAndList() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            String name;
            int length;
            int i;
            BlobContainer container = store.blobContainer(new BlobPath());
            ESBlobStoreContainerTestCase.assertThat((Object)container.listBlobs().size(), (Matcher)CoreMatchers.equalTo((Object)0));
            int numberOfFooBlobs = ESBlobStoreContainerTestCase.randomIntBetween(0, 10);
            int numberOfBarBlobs = ESBlobStoreContainerTestCase.randomIntBetween(3, 20);
            HashMap<String, Long> generatedBlobs = new HashMap<String, Long>();
            for (i = 0; i < numberOfFooBlobs; ++i) {
                length = ESBlobStoreContainerTestCase.randomIntBetween(10, 100);
                name = "foo-" + i + "-";
                generatedBlobs.put(name, Long.valueOf(length));
                ESBlobStoreTestCase.writeRandomBlob(container, name, length);
            }
            for (i = 1; i < numberOfBarBlobs; ++i) {
                length = ESBlobStoreContainerTestCase.randomIntBetween(10, 100);
                name = "bar-" + i + "-";
                generatedBlobs.put(name, Long.valueOf(length));
                ESBlobStoreTestCase.writeRandomBlob(container, name, length);
            }
            int length2 = ESBlobStoreContainerTestCase.randomIntBetween(10, 100);
            String name2 = "bar-0-";
            generatedBlobs.put(name2, Long.valueOf(length2));
            byte[] data = ESBlobStoreTestCase.writeRandomBlob(container, name2, length2);
            Map blobs = container.listBlobs();
            ESBlobStoreContainerTestCase.assertThat((Object)blobs.size(), (Matcher)CoreMatchers.equalTo((Object)(numberOfFooBlobs + numberOfBarBlobs)));
            for (Map.Entry generated : generatedBlobs.entrySet()) {
                BlobMetaData blobMetaData = (BlobMetaData)blobs.get(generated.getKey());
                ESBlobStoreContainerTestCase.assertThat((String)((String)generated.getKey()), (Object)blobMetaData, (Matcher)CoreMatchers.notNullValue());
                ESBlobStoreContainerTestCase.assertThat((Object)blobMetaData.name(), (Matcher)CoreMatchers.equalTo(generated.getKey()));
                ESBlobStoreContainerTestCase.assertThat((Object)blobMetaData.length(), (Matcher)CoreMatchers.equalTo(generated.getValue()));
            }
            ESBlobStoreContainerTestCase.assertThat((Object)container.listBlobsByPrefix("foo-").size(), (Matcher)CoreMatchers.equalTo((Object)numberOfFooBlobs));
            ESBlobStoreContainerTestCase.assertThat((Object)container.listBlobsByPrefix("bar-").size(), (Matcher)CoreMatchers.equalTo((Object)numberOfBarBlobs));
            ESBlobStoreContainerTestCase.assertThat((Object)container.listBlobsByPrefix("baz-").size(), (Matcher)CoreMatchers.equalTo((Object)0));
            String newName = "bar-new";
            container.move(name2, newName);
            ESBlobStoreContainerTestCase.assertThat((Object)container.listBlobsByPrefix(name2).size(), (Matcher)CoreMatchers.equalTo((Object)0));
            blobs = container.listBlobsByPrefix(newName);
            ESBlobStoreContainerTestCase.assertThat((Object)blobs.size(), (Matcher)CoreMatchers.equalTo((Object)1));
            ESBlobStoreContainerTestCase.assertThat((Object)((BlobMetaData)blobs.get(newName)).length(), (Matcher)CoreMatchers.equalTo(generatedBlobs.get(name2)));
            ESBlobStoreContainerTestCase.assertThat((Object)data, (Matcher)CoreMatchers.equalTo((Object)ESBlobStoreTestCase.readBlobFully(container, newName, length2)));
        }
    }

    public void testDeleteBlob() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            String blobName = "foobar";
            BlobContainer container = store.blobContainer(new BlobPath());
            ESBlobStoreContainerTestCase.expectThrows(IOException.class, () -> container.deleteBlob("foobar"));
            byte[] data = ESBlobStoreTestCase.randomBytes(ESBlobStoreContainerTestCase.randomIntBetween(10, ESBlobStoreContainerTestCase.scaledRandomIntBetween(1024, 65536)));
            BytesArray bytesArray = new BytesArray(data);
            this.writeBlob(container, "foobar", bytesArray);
            container.deleteBlob("foobar");
            ESBlobStoreContainerTestCase.expectThrows(IOException.class, () -> container.deleteBlob("foobar"));
        }
    }

    public void testVerifyOverwriteFails() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            String blobName = "foobar";
            BlobContainer container = store.blobContainer(new BlobPath());
            byte[] data = ESBlobStoreTestCase.randomBytes(ESBlobStoreContainerTestCase.randomIntBetween(10, ESBlobStoreContainerTestCase.scaledRandomIntBetween(1024, 65536)));
            BytesArray bytesArray = new BytesArray(data);
            this.writeBlob(container, "foobar", bytesArray);
            ESBlobStoreContainerTestCase.expectThrows(IOException.class, () -> this.writeBlob(container, "foobar", bytesArray));
            container.deleteBlob("foobar");
            this.writeBlob(container, "foobar", bytesArray);
        }
    }

    private void writeBlob(BlobContainer container, String blobName, BytesArray bytesArray) throws IOException {
        try (StreamInput stream = bytesArray.streamInput();){
            container.writeBlob(blobName, (InputStream)stream, (long)bytesArray.length());
        }
    }

    protected abstract BlobStore newBlobStore() throws IOException;
}

