/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.annotations.TestGroup;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.CompositeTestCluster;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ExternalNode;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.NodeConfigurationSource;
import org.elasticsearch.test.TestCluster;
import org.elasticsearch.test.discovery.TestZenDiscovery;
import org.elasticsearch.test.junit.annotations.TestLogging;
import org.elasticsearch.test.junit.listeners.LoggingListener;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@Backwards
@ESIntegTestCase.ClusterScope(minNumDataNodes=0, maxNumDataNodes=2, scope=ESIntegTestCase.Scope.SUITE, numClientNodes=0, transportClientRatio=0.0)
public abstract class ESBackcompatTestCase
extends ESIntegTestCase {
    public static final String TESTS_BACKWARDS_COMPATIBILITY = "tests.bwc";
    public static final String TESTS_BACKWARDS_COMPATIBILITY_VERSION = "tests.bwc.version";
    public static final String TESTS_BACKWARDS_COMPATIBILITY_PATH = "tests.bwc.path";
    private static final String TESTS_COMPATIBILITY = "tests.compatibility";
    private static final Version GLOBAL_COMPATIBILITY_VERSION = Version.fromString((String)ESBackcompatTestCase.compatibilityVersionProperty());

    private static Path backwardsCompatibilityPath() {
        String path = System.getProperty(TESTS_BACKWARDS_COMPATIBILITY_PATH);
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Must specify backwards test path with property tests.bwc.path");
        }
        String version = System.getProperty(TESTS_BACKWARDS_COMPATIBILITY_VERSION);
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("Must specify backwards test version with property tests.bwc.version");
        }
        if (Version.fromString((String)version).before(Version.CURRENT.minimumCompatibilityVersion())) {
            throw new IllegalArgumentException("Backcompat elasticsearch version must be same major version as current. backcompat: " + version + ", current: " + Version.CURRENT.toString());
        }
        Path file = PathUtils.get((String)path, (String[])new String[]{"elasticsearch-" + version});
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IllegalArgumentException("Backwards tests location is missing: " + file.toAbsolutePath());
        }
        if (!Files.isDirectory(file, new LinkOption[0])) {
            throw new IllegalArgumentException("Backwards tests location is not a directory: " + file.toAbsolutePath());
        }
        return file;
    }

    public Version compatibilityVersion() {
        return this.compatibilityVersion(((Object)((Object)this)).getClass());
    }

    private Version compatibilityVersion(Class<?> clazz) {
        if (clazz == Object.class || clazz == ESIntegTestCase.class) {
            return ESBackcompatTestCase.globalCompatibilityVersion();
        }
        CompatibilityVersion annotation = clazz.getAnnotation(CompatibilityVersion.class);
        if (annotation != null) {
            return Version.min((Version)Version.fromId((int)annotation.version()), (Version)this.compatibilityVersion(clazz.getSuperclass()));
        }
        return this.compatibilityVersion(clazz.getSuperclass());
    }

    public static Version globalCompatibilityVersion() {
        return GLOBAL_COMPATIBILITY_VERSION;
    }

    private static String compatibilityVersionProperty() {
        String version = System.getProperty(TESTS_COMPATIBILITY);
        if (Strings.hasLength((String)version)) {
            return version;
        }
        return System.getProperty(TESTS_BACKWARDS_COMPATIBILITY_VERSION);
    }

    public CompositeTestCluster backwardsCluster() {
        return (CompositeTestCluster)ESBackcompatTestCase.cluster();
    }

    @Override
    protected TestCluster buildTestCluster(ESIntegTestCase.Scope scope, long seed) throws IOException {
        TestCluster cluster = super.buildTestCluster(scope, seed);
        ExternalNode externalNode = new ExternalNode(ESBackcompatTestCase.backwardsCompatibilityPath(), ESBackcompatTestCase.randomLong(), new NodeConfigurationSource(){

            @Override
            public Settings nodeSettings(int nodeOrdinal) {
                return ESBackcompatTestCase.this.externalNodeSettings(nodeOrdinal);
            }

            @Override
            public Collection<Class<? extends Plugin>> nodePlugins() {
                return Collections.emptyList();
            }

            @Override
            public Settings transportClientSettings() {
                return this.transportClientSettings();
            }
        });
        return new CompositeTestCluster((InternalTestCluster)cluster, ESBackcompatTestCase.between(this.minExternalNodes(), this.maxExternalNodes()), externalNode);
    }

    private Settings addLoggerSettings(Settings externalNodesSettings) {
        TestLogging logging = ((Object)((Object)this)).getClass().getAnnotation(TestLogging.class);
        Map<String, String> loggingLevels = LoggingListener.getLoggersAndLevelsFromAnnotation(logging);
        Settings.Builder finalSettings = Settings.builder();
        if (loggingLevels != null) {
            for (Map.Entry<String, String> level : loggingLevels.entrySet()) {
                finalSettings.put("logger." + level.getKey(), level.getValue());
            }
        }
        finalSettings.put(externalNodesSettings);
        return finalSettings.build();
    }

    protected int minExternalNodes() {
        return 1;
    }

    protected int maxExternalNodes() {
        return 2;
    }

    @Override
    protected int maximumNumberOfReplicas() {
        return 1;
    }

    protected Settings requiredSettings() {
        return ExternalNode.REQUIRED_SETTINGS;
    }

    @Override
    protected Settings nodeSettings(int nodeOrdinal) {
        return this.commonNodeSettings(nodeOrdinal);
    }

    public void assertAllShardsOnNodes(String index, String pattern) {
        ClusterState clusterState = ((ClusterStateResponse)ESBackcompatTestCase.client().admin().cluster().prepareState().execute().actionGet()).getState();
        for (IndexRoutingTable indexRoutingTable : clusterState.routingTable()) {
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (shardRouting.currentNodeId() == null || !index.equals(shardRouting.getIndexName())) continue;
                    String name = clusterState.nodes().get(shardRouting.currentNodeId()).getName();
                    ESBackcompatTestCase.assertThat((String)("Allocated on new node: " + name), (Object)Regex.simpleMatch((String)pattern, (String)name), (Matcher)Matchers.is((Object)true));
                }
            }
        }
    }

    protected Settings commonNodeSettings(int nodeOrdinal) {
        Settings.Builder builder = Settings.builder().put(this.requiredSettings());
        builder.put("transport.type", ESBackcompatTestCase.randomBoolean() ? "netty3" : "netty4");
        builder.put(TestZenDiscovery.USE_MOCK_PINGS.getKey(), false);
        return builder.build();
    }

    protected Settings externalNodeSettings(int nodeOrdinal) {
        return this.addLoggerSettings(this.commonNodeSettings(nodeOrdinal));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface CompatibilityVersion {
        public int version();
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @TestGroup(enabled=false, sysProperty="tests.bwc")
    public static @interface Backwards {
    }
}

