/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.discovery;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.discovery.zen.PingContextProvider;
import org.elasticsearch.discovery.zen.ZenPing;

public final class MockZenPing
extends AbstractComponent
implements ZenPing {
    static final Map<ClusterName, Set<MockZenPing>> activeNodesPerCluster = new HashMap<ClusterName, Set<MockZenPing>>();
    private Set<MockZenPing> lastDiscoveredPings = null;
    private volatile PingContextProvider contextProvider;

    public MockZenPing(Settings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(PingContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        assert (contextProvider != null);
        Map<ClusterName, Set<MockZenPing>> map = activeNodesPerCluster;
        synchronized (map) {
            boolean added = this.getActiveNodesForCurrentCluster().add(this);
            assert (added);
            activeNodesPerCluster.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(Consumer<ZenPing.PingCollection> resultsConsumer, TimeValue timeout) {
        this.logger.info("pinging using mock zen ping");
        Map<ClusterName, Set<MockZenPing>> map = activeNodesPerCluster;
        synchronized (map) {
            Set<MockZenPing> activeNodes = this.getActiveNodesForCurrentCluster();
            if (activeNodes.equals(this.lastDiscoveredPings)) {
                try {
                    this.logger.trace("nothing has changed since the last ping. waiting for a change");
                    activeNodesPerCluster.wait(timeout.millis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                activeNodes = this.getActiveNodesForCurrentCluster();
            }
            this.lastDiscoveredPings = activeNodes;
            ZenPing.PingCollection pingCollection = new ZenPing.PingCollection();
            activeNodes.stream().filter(p -> p != this).map(MockZenPing::getPingResponse).forEach(arg_0 -> ((ZenPing.PingCollection)pingCollection).addPing(arg_0));
            resultsConsumer.accept(pingCollection);
        }
    }

    private ClusterName getClusterName() {
        return this.contextProvider.clusterState().getClusterName();
    }

    private ZenPing.PingResponse getPingResponse() {
        ClusterState clusterState = this.contextProvider.clusterState();
        return new ZenPing.PingResponse(clusterState.nodes().getLocalNode(), clusterState.nodes().getMasterNode(), clusterState);
    }

    private Set<MockZenPing> getActiveNodesForCurrentCluster() {
        assert (Thread.holdsLock(activeNodesPerCluster));
        return activeNodesPerCluster.computeIfAbsent(this.getClusterName(), clusterName -> ConcurrentCollections.newConcurrentSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClusterName, Set<MockZenPing>> map = activeNodesPerCluster;
        synchronized (map) {
            boolean found = this.getActiveNodesForCurrentCluster().remove((Object)this);
            assert (found);
            activeNodesPerCluster.notifyAll();
        }
    }
}

