/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.LocalClusterUpdateTask;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.SingleNodeDisruption;

public class BlockClusterStateProcessing
extends SingleNodeDisruption {
    AtomicReference<CountDownLatch> disruptionLatch = new AtomicReference();

    public BlockClusterStateProcessing(Random random) {
        this(null, random);
    }

    public BlockClusterStateProcessing(String disruptedNode, Random random) {
        super(random);
        this.disruptedNode = disruptedNode;
    }

    @Override
    public void startDisrupting() {
        String disruptionNodeCopy = this.disruptedNode;
        if (disruptionNodeCopy == null) {
            return;
        }
        ClusterService clusterService = this.cluster.getInstance(ClusterService.class, disruptionNodeCopy);
        if (clusterService == null) {
            return;
        }
        this.logger.info("delaying cluster state updates on node [{}]", (Object)disruptionNodeCopy);
        boolean success = this.disruptionLatch.compareAndSet(null, new CountDownLatch(1));
        assert (success) : "startDisrupting called without waiting on stopDisrupting to complete";
        final CountDownLatch started = new CountDownLatch(1);
        clusterService.submitStateUpdateTask("service_disruption_block", (ClusterStateTaskConfig)new LocalClusterUpdateTask(Priority.IMMEDIATE){

            public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) throws Exception {
                started.countDown();
                CountDownLatch latch = BlockClusterStateProcessing.this.disruptionLatch.get();
                if (latch != null) {
                    latch.await();
                }
                return 1.unchanged();
            }

            public void onFailure(String source, Exception e) {
                BlockClusterStateProcessing.this.logger.error("unexpected error during disruption", (Throwable)e);
            }
        });
        try {
            started.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stopDisrupting() {
        CountDownLatch latch = this.disruptionLatch.get();
        if (latch != null) {
            latch.countDown();
        }
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMinutes((long)0L);
    }
}

