/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.lang.management.ThreadInfo;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.disruption.LongGCDisruption;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class LongGCDisruptionTest
extends ESTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockingTimeout() throws Exception {
        String nodeName = "test_node";
        LongGCDisruption disruption = new LongGCDisruption(LongGCDisruptionTest.random(), "test_node"){

            @Override
            protected Pattern[] getUnsafeClasses() {
                return new Pattern[]{Pattern.compile(LockedExecutor.class.getSimpleName())};
            }

            @Override
            protected long getStoppingTimeoutInMillis() {
                return 100L;
            }
        };
        AtomicBoolean stop = new AtomicBoolean();
        CountDownLatch underLock = new CountDownLatch(1);
        CountDownLatch pauseUnderLock = new CountDownLatch(1);
        LockedExecutor lockedExecutor = new LockedExecutor();
        AtomicLong ops = new AtomicLong();
        try {
            Thread[] threads = new Thread[10];
            for (int i = 0; i < 10; ++i) {
                boolean lockedExec = i < 9 && LongGCDisruptionTest.randomBoolean() || i == 0;
                threads[i] = new Thread(() -> {
                    while (!stop.get()) {
                        if (lockedExec) {
                            lockedExecutor.executeLocked(() -> {
                                try {
                                    underLock.countDown();
                                    ops.incrementAndGet();
                                    pauseUnderLock.await();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            });
                            continue;
                        }
                        ops.incrementAndGet();
                    }
                });
                threads[i].setName("[test_node][" + i + "]");
                threads[i].start();
            }
            underLock.await();
            RuntimeException e = (RuntimeException)LongGCDisruptionTest.expectThrows(RuntimeException.class, disruption::startDisrupting);
            LongGCDisruptionTest.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"stopping node threads took too long"));
        }
        finally {
            stop.set(true);
            pauseUnderLock.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotBlockingUnsafeStackTraces() throws Exception {
        String nodeName = "test_node";
        LongGCDisruption disruption = new LongGCDisruption(LongGCDisruptionTest.random(), "test_node"){

            @Override
            protected Pattern[] getUnsafeClasses() {
                return new Pattern[]{Pattern.compile(LockedExecutor.class.getSimpleName())};
            }
        };
        AtomicBoolean stop = new AtomicBoolean();
        LockedExecutor lockedExecutor = new LockedExecutor();
        AtomicLong ops = new AtomicLong();
        try {
            Thread[] threads = new Thread[10];
            for (int i = 0; i < 10; ++i) {
                threads[i] = new Thread(() -> {
                    int iter = 0;
                    while (!stop.get()) {
                        if (iter % 2 == 0) {
                            lockedExecutor.executeLocked(() -> {
                                Thread.yield();
                                ops.incrementAndGet();
                            });
                        } else {
                            Thread.yield();
                            ops.incrementAndGet();
                        }
                        ++iter;
                    }
                });
                threads[i].setName("[test_node][" + i + "]");
                threads[i].start();
            }
            disruption.startDisrupting();
            long first = ops.get();
            LongGCDisruptionTest.assertThat((Object)lockedExecutor.lock.isLocked(), (Matcher)Matchers.equalTo((Object)false));
            Thread.sleep(100L);
            LongGCDisruptionTest.assertThat((Object)ops.get(), (Matcher)Matchers.equalTo((Object)first));
            disruption.stopDisrupting();
            LongGCDisruptionTest.assertBusy(() -> LongGCDisruptionTest.assertThat((Object)ops.get(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(first))));
        }
        finally {
            stop.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockDetection() throws Exception {
        String disruptedNodeName = "disrupted_node";
        String blockedNodeName = "blocked_node";
        final CountDownLatch waitForBlockDetectionResult = new CountDownLatch(1);
        final AtomicReference blockDetectionResult = new AtomicReference();
        LongGCDisruption disruption = new LongGCDisruption(LongGCDisruptionTest.random(), "disrupted_node"){

            @Override
            protected Pattern[] getUnsafeClasses() {
                return new Pattern[0];
            }

            @Override
            protected void onBlockDetected(ThreadInfo blockedThread, @Nullable ThreadInfo blockingThread) {
                blockDetectionResult.set(blockedThread);
                waitForBlockDetectionResult.countDown();
            }

            @Override
            protected long getBlockDetectionIntervalInMillis() {
                return 10L;
            }
        };
        if (!disruption.isBlockDetectionSupported()) {
            return;
        }
        AtomicBoolean stop = new AtomicBoolean();
        CountDownLatch underLock = new CountDownLatch(1);
        CountDownLatch pauseUnderLock = new CountDownLatch(1);
        LockedExecutor lockedExecutor = new LockedExecutor();
        AtomicLong ops = new AtomicLong();
        try {
            Thread thread;
            boolean lockedExec;
            int i;
            for (i = 0; i < 5; ++i) {
                lockedExec = i < 4 && LongGCDisruptionTest.randomBoolean() || i == 0;
                thread = new Thread(() -> {
                    while (!stop.get()) {
                        if (lockedExec) {
                            lockedExecutor.executeLocked(() -> {
                                try {
                                    underLock.countDown();
                                    ops.incrementAndGet();
                                    pauseUnderLock.await();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            });
                            continue;
                        }
                        ops.incrementAndGet();
                    }
                });
                thread.setName("[disrupted_node][" + i + "]");
                thread.start();
            }
            for (i = 0; i < 5; ++i) {
                lockedExec = i < 4 && LongGCDisruptionTest.randomBoolean() || i == 0;
                thread = new Thread(() -> {
                    while (!stop.get()) {
                        if (lockedExec) {
                            lockedExecutor.executeLocked(() -> ops.incrementAndGet());
                            continue;
                        }
                        ops.incrementAndGet();
                    }
                });
                thread.setName("[blocked_node][" + i + "]");
                thread.start();
            }
            underLock.await();
            disruption.startDisrupting();
            waitForBlockDetectionResult.await(30L, TimeUnit.SECONDS);
            disruption.stopDisrupting();
            ThreadInfo threadInfo = (ThreadInfo)blockDetectionResult.get();
            LongGCDisruptionTest.assertNotNull((Object)threadInfo);
            LongGCDisruptionTest.assertThat((Object)threadInfo.getThreadName(), (Matcher)Matchers.containsString((String)"[blocked_node]"));
            LongGCDisruptionTest.assertThat((Object)threadInfo.getLockOwnerName(), (Matcher)Matchers.containsString((String)"[disrupted_node]"));
            LongGCDisruptionTest.assertThat((Object)threadInfo.getLockInfo().getClassName(), (Matcher)Matchers.containsString((String)ReentrantLock.class.getName()));
        }
        finally {
            stop.set(true);
            pauseUnderLock.countDown();
        }
    }

    static class LockedExecutor {
        ReentrantLock lock = new ReentrantLock();

        LockedExecutor() {
        }

        public void executeLocked(Runnable r) {
            this.lock.lock();
            try {
                r.run();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

