/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.disruption.NetworkDisruption;

public class NetworkDisruptionTests
extends ESTestCase {
    public void testTwoPartitions() {
        Set<String> partition1 = this.generateRandomStringSet(1, 10);
        Set<String> partition2 = this.generateRandomStringSet(1, 10);
        NetworkDisruption.TwoPartitions topology = new NetworkDisruption.TwoPartitions(partition1, partition2);
        this.checkTwoPartitions(topology, partition1, partition2);
    }

    public void testRandomTwoPartitions() {
        NetworkDisruption.TwoPartitions topology = NetworkDisruption.TwoPartitions.random(NetworkDisruptionTests.random(), this.generateRandomStringSet(2, 20));
        Set<String> partition1 = topology.getNodesSideOne();
        Set<String> partition2 = topology.getNodesSideTwo();
        this.checkTwoPartitions(topology, partition1, partition2);
    }

    private void checkTwoPartitions(NetworkDisruption.TwoPartitions topology, Set<String> partition1, Set<String> partition2) {
        for (int i = 0; i < 10; ++i) {
            NetworkDisruptionTests.assertTrue((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition1), NetworkDisruptionTests.randomFrom(partition2)));
            NetworkDisruptionTests.assertTrue((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition2), NetworkDisruptionTests.randomFrom(partition1)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition1), NetworkDisruptionTests.randomFrom(partition1)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition2), NetworkDisruptionTests.randomFrom(partition2)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomAlphaOfLength(10), NetworkDisruptionTests.randomFrom(partition1)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomAlphaOfLength(10), NetworkDisruptionTests.randomFrom(partition2)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition1), NetworkDisruptionTests.randomAlphaOfLength(10)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition2), NetworkDisruptionTests.randomAlphaOfLength(10)));
        }
        NetworkDisruptionTests.assertTrue((topology.getMajoritySide().size() >= topology.getMinoritySide().size() ? 1 : 0) != 0);
    }

    public void testIsolateAll() {
        Set<String> nodes = this.generateRandomStringSet(1, 10);
        NetworkDisruption.IsolateAllNodes topology = new NetworkDisruption.IsolateAllNodes(nodes);
        for (int i = 0; i < 10; ++i) {
            String node2;
            String node1 = NetworkDisruptionTests.randomFrom(nodes);
            if (node1.equals(node2 = NetworkDisruptionTests.randomFrom(nodes))) continue;
            NetworkDisruptionTests.assertTrue((boolean)topology.nodes().contains(node1));
            NetworkDisruptionTests.assertTrue((boolean)topology.nodes().contains(node2));
            NetworkDisruptionTests.assertTrue((boolean)((NetworkDisruption.DisruptedLinks)topology).disrupt(node1, node2));
        }
    }

    public void testBridge() {
        Set<String> partition1 = this.generateRandomStringSet(1, 10);
        Set<String> partition2 = this.generateRandomStringSet(1, 10);
        String bridgeNode = NetworkDisruptionTests.randomAlphaOfLength(10);
        NetworkDisruption.Bridge topology = new NetworkDisruption.Bridge(bridgeNode, partition1, partition2);
        this.checkBridge(topology, bridgeNode, partition1, partition2);
    }

    public void testRandomBridge() {
        NetworkDisruption.Bridge topology = NetworkDisruption.Bridge.random(NetworkDisruptionTests.random(), this.generateRandomStringSet(3, 20));
        String bridgeNode = topology.getBridgeNode();
        Set<String> partition1 = topology.getNodesSideOne();
        Set<String> partition2 = topology.getNodesSideTwo();
        this.checkBridge(topology, bridgeNode, partition1, partition2);
    }

    private void checkBridge(NetworkDisruption.Bridge topology, String bridgeNode, Set<String> partition1, Set<String> partition2) {
        for (int i = 0; i < 10; ++i) {
            NetworkDisruptionTests.assertTrue((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition1), NetworkDisruptionTests.randomFrom(partition2)));
            NetworkDisruptionTests.assertTrue((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition2), NetworkDisruptionTests.randomFrom(partition1)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition1), NetworkDisruptionTests.randomFrom(partition1)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition1), bridgeNode));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(bridgeNode, NetworkDisruptionTests.randomFrom(partition1)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition2), NetworkDisruptionTests.randomFrom(partition2)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition2), bridgeNode));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(bridgeNode, NetworkDisruptionTests.randomFrom(partition2)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomAlphaOfLength(10), NetworkDisruptionTests.randomFrom(partition1)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomAlphaOfLength(10), NetworkDisruptionTests.randomFrom(partition2)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomAlphaOfLength(10), bridgeNode));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition1), NetworkDisruptionTests.randomAlphaOfLength(10)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(NetworkDisruptionTests.randomFrom(partition2), NetworkDisruptionTests.randomAlphaOfLength(10)));
            NetworkDisruptionTests.assertFalse((boolean)topology.disrupt(bridgeNode, NetworkDisruptionTests.randomAlphaOfLength(10)));
        }
    }

    private Set<String> generateRandomStringSet(int minSize, int maxSize) {
        assert (maxSize >= minSize);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < minSize + NetworkDisruptionTests.randomInt(maxSize - minSize); ++i) {
            result.add(NetworkDisruptionTests.randomAlphaOfLength(10));
        }
        return result;
    }
}

