/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.engine;

import java.io.IOException;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.test.engine.MockEngineSupport;

final class MockInternalEngine
extends InternalEngine {
    private MockEngineSupport support;
    private final boolean randomizeFlushOnClose;
    private Class<? extends FilterDirectoryReader> wrapperClass;

    MockInternalEngine(EngineConfig config, Class<? extends FilterDirectoryReader> wrapper) throws EngineException {
        super(config);
        this.randomizeFlushOnClose = !config.getIndexSettings().isOnSharedFilesystem();
        this.wrapperClass = wrapper;
    }

    private synchronized MockEngineSupport support() {
        if (this.support == null) {
            this.support = new MockEngineSupport(this.config(), this.wrapperClass);
        }
        return this.support;
    }

    public void close() throws IOException {
        switch (this.support().flushOrClose(MockEngineSupport.CloseAction.CLOSE)) {
            case FLUSH_AND_CLOSE: {
                this.flushAndCloseInternal();
                break;
            }
            case CLOSE: {
                super.close();
            }
        }
    }

    public void flushAndClose() throws IOException {
        if (this.randomizeFlushOnClose) {
            switch (this.support().flushOrClose(MockEngineSupport.CloseAction.FLUSH_AND_CLOSE)) {
                case FLUSH_AND_CLOSE: {
                    this.flushAndCloseInternal();
                    break;
                }
                case CLOSE: {
                    super.close();
                }
            }
        } else {
            this.flushAndCloseInternal();
        }
    }

    private void flushAndCloseInternal() throws IOException {
        if (!this.support().isFlushOnCloseDisabled()) {
            super.flushAndClose();
        } else {
            super.close();
        }
    }

    protected Engine.Searcher newSearcher(String source, IndexSearcher searcher, SearcherManager manager) throws EngineException {
        Engine.Searcher engineSearcher = super.newSearcher(source, searcher, manager);
        return this.support().wrapSearcher(source, engineSearcher, searcher, manager);
    }
}

