/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestPath;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;

public class ClientYamlTestClient {
    private static final Logger logger = Loggers.getLogger(ClientYamlTestClient.class);
    private static final ContentType YAML_CONTENT_TYPE = ContentType.create((String)"application/yaml");
    private final ClientYamlSuiteRestSpec restSpec;
    private final RestClient restClient;
    private final Version esVersion;
    private final Map<HttpHost, Version> hostVersionMap;

    public ClientYamlTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts, Version esVersion, Map<HttpHost, Version> hostVersionMap) throws IOException {
        assert (hosts.size() > 0);
        this.restSpec = restSpec;
        this.restClient = restClient;
        this.esVersion = esVersion;
        this.hostVersionMap = hostVersionMap;
    }

    public Version getEsVersion() {
        return this.esVersion;
    }

    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, HttpEntity entity, Map<String, String> headers) throws IOException {
        String requestPath;
        String requestMethod;
        if ("raw".equals(apiName)) {
            HashMap<String, String> queryStringParams = new HashMap<String, String>(params);
            String method = (String)Objects.requireNonNull(queryStringParams.remove("method"), "Method must be set to use raw request");
            String path = "/" + (String)Objects.requireNonNull(queryStringParams.remove("path"), "Path must be set to use raw request");
            try {
                Response response = this.restClient.performRequest(method, path, queryStringParams, entity, new Header[0]);
                return new ClientYamlTestResponse(response, this.hostVersionMap.get(response.getHost()));
            }
            catch (ResponseException e) {
                throw new ClientYamlTestResponseException(e, this.hostVersionMap.get(e.getResponse().getHost()));
            }
        }
        ClientYamlSuiteRestApi restApi = this.restApi(apiName);
        HashMap<String, String> pathParts = new HashMap<String, String>();
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (restApi.getPathParts().contains(entry.getKey())) {
                pathParts.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (restApi.getParams().contains(entry.getKey()) || this.restSpec.isGlobalParameter(entry.getKey()) || this.restSpec.isClientParameter(entry.getKey())) {
                queryStringParams.put(entry.getKey(), entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("param [" + entry.getKey() + "] not supported in [" + restApi.getName() + "] api");
        }
        List<String> supportedMethods = restApi.getSupportedMethods(pathParts.keySet());
        if (entity != null) {
            if (!restApi.isBodySupported()) {
                throw new IllegalArgumentException("body is not supported by [" + restApi.getName() + "] api");
            }
            String contentType = entity.getContentType().getValue();
            if (ClientYamlTestClient.sendBodyAsSourceParam(supportedMethods, contentType)) {
                logger.debug("sending the request body as source param with GET method");
                queryStringParams.put("source", EntityUtils.toString((HttpEntity)entity));
                if (this.esVersion.onOrAfter(Version.V_5_3_0_UNRELEASED)) {
                    queryStringParams.put("source_content_type", contentType);
                }
                requestMethod = "GET";
                entity = null;
            } else {
                requestMethod = (String)RandomizedTest.randomFrom(supportedMethods);
            }
        } else {
            if (restApi.isBodyRequired()) {
                throw new IllegalArgumentException("body is required by [" + restApi.getName() + "] api");
            }
            requestMethod = (String)RandomizedTest.randomFrom(supportedMethods);
        }
        ClientYamlSuiteRestPath restPath = (ClientYamlSuiteRestPath)RandomizedTest.randomFrom((Object[])restApi.getFinalPaths(pathParts));
        if (restPath.getPathParts().length == 0) {
            requestPath = "/";
        } else {
            StringBuilder finalPath = new StringBuilder();
            for (String pathPart : restPath.getPathParts()) {
                try {
                    finalPath.append('/');
                    URI uri = new URI(null, null, null, -1, "/" + pathPart, null, null);
                    finalPath.append(uri.getRawPath().substring(1).replaceAll("/", "%2F"));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("unable to build uri", e);
                }
            }
            requestPath = finalPath.toString();
        }
        Header[] requestHeaders = new Header[headers.size()];
        int index = 0;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            logger.info("Adding header {}\n with value {}", (Object)header.getKey(), (Object)header.getValue());
            requestHeaders[index++] = new BasicHeader(header.getKey(), header.getValue());
        }
        logger.debug("calling api [{}]", (Object)apiName);
        try {
            Response response = this.restClient.performRequest(requestMethod, requestPath, queryStringParams, entity, requestHeaders);
            return new ClientYamlTestResponse(response, this.hostVersionMap.get(response.getHost()));
        }
        catch (ResponseException e) {
            throw new ClientYamlTestResponseException(e, this.hostVersionMap.get(e.getResponse().getHost()));
        }
    }

    private static boolean sendBodyAsSourceParam(List<String> supportedMethods, String contentType) {
        if (supportedMethods.contains("GET") && (contentType.startsWith(ContentType.APPLICATION_JSON.getMimeType()) || contentType.startsWith(YAML_CONTENT_TYPE.getMimeType()))) {
            return RandomizedTest.rarely();
        }
        return false;
    }

    private ClientYamlSuiteRestApi restApi(String apiName) {
        ClientYamlSuiteRestApi restApi = this.restSpec.getApi(apiName);
        if (restApi == null) {
            throw new IllegalArgumentException("rest api [" + apiName + "] doesn't exist in the rest spec");
        }
        return restApi;
    }
}

