/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.test.rest.yaml.ObjectPath;

public class Stash
implements ToXContent {
    private static final Pattern EXTENDED_KEY = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final Logger logger = Loggers.getLogger(Stash.class);
    public static final Stash EMPTY = new Stash();
    private final Map<String, Object> stash = new HashMap<String, Object>();
    private final ObjectPath stashObjectPath = new ObjectPath(this.stash);

    public void stashValue(String key, Object value) {
        logger.trace("stashing [{}]=[{}]", (Object)key, value);
        Object old = this.stash.put(key, value);
        if (old != null && old != value) {
            logger.trace("replaced stashed value [{}] with same key [{}]", old, (Object)key);
        }
    }

    public void clear() {
        this.stash.clear();
    }

    public boolean containsStashedValue(Object key) {
        if (key == null || !(key instanceof CharSequence)) {
            return false;
        }
        String stashKey = key.toString();
        if (!Strings.hasLength((String)stashKey)) {
            return false;
        }
        if (stashKey.startsWith("$")) {
            return true;
        }
        return EXTENDED_KEY.matcher(stashKey).find();
    }

    public Object getValue(String key) throws IOException {
        if (key.charAt(0) == '$' && key.charAt(1) != '{') {
            return this.unstash(key.substring(1));
        }
        Matcher matcher = EXTENDED_KEY.matcher(key);
        StringBuffer result = new StringBuffer(key.length());
        if (!matcher.find()) {
            throw new IllegalArgumentException("Doesn't contain any stash keys [" + key + "]");
        }
        do {
            matcher.appendReplacement(result, Matcher.quoteReplacement(this.unstash(matcher.group(1)).toString()));
        } while (matcher.find());
        matcher.appendTail(result);
        return result.toString();
    }

    private Object unstash(String key) throws IOException {
        Object stashedValue = this.stashObjectPath.evaluate(key);
        if (stashedValue == null) {
            throw new IllegalArgumentException("stashed value not found for key [" + key + "]");
        }
        return stashedValue;
    }

    public Map<String, Object> replaceStashedValues(Map<String, Object> map) throws IOException {
        HashMap<String, Object> copy = new HashMap<String, Object>(map);
        this.unstashObject(copy);
        return copy;
    }

    private void unstashObject(Object obj) throws IOException {
        if (obj instanceof List) {
            List list = (List)obj;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (this.containsStashedValue(e)) {
                    list.set(i, this.getValue(e.toString()));
                    continue;
                }
                this.unstashObject(e);
            }
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                if (this.containsStashedValue(entry.getValue())) {
                    entry.setValue(this.getValue(entry.getValue().toString()));
                    continue;
                }
                this.unstashObject(entry.getValue());
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("stash", this.stash);
        return builder;
    }
}

