/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client;

import java.io.IOException;
import org.filesys.client.SMBFile;
import org.filesys.client.SMBPacket;
import org.filesys.client.Session;
import org.filesys.client.info.FileInfo;
import org.filesys.smb.SMBDate;
import org.filesys.smb.SMBException;
import org.filesys.util.DataPacker;

public class CoreFile
extends SMBFile {
    private static final int DataSize = 4000;
    private static final int PacketSize = 4064;
    private static final int WriteDataOffset = 52;

    protected CoreFile(Session sess, FileInfo finfo, int fid) {
        super(sess, finfo, fid);
    }

    @Override
    public void Close(SMBDate wrDateTime) throws IOException, SMBException {
        if (this.m_txlen > 0) {
            this.Flush();
        }
        SMBPacket pkt = new SMBPacket();
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.setCommand(4);
        pkt.setParameterCount(3);
        pkt.setParameter(0, this.m_FID);
        if (wrDateTime != null) {
            pkt.setParameter(1, wrDateTime.asSMBTime());
            pkt.setParameter(2, wrDateTime.asSMBDate());
        } else {
            pkt.setParameter(1, 0);
            pkt.setParameter(2, 0);
        }
        this.setStateFlag(2, true);
        try {
            pkt.ExchangeSMB(this.m_sess, pkt);
        }
        catch (IOException ex) {
            return;
        }
        this.m_rxpkt = null;
        this.m_txpkt = null;
    }

    @Override
    public void Flush() throws IOException, SMBException {
        if (this.m_txlen > 0) {
            this.WriteData();
        }
    }

    @Override
    public int Read(byte[] buf, int siz, int offset) throws IOException, SMBException {
        int retlen;
        int rxlen;
        if (this.isClosed()) {
            return 0;
        }
        int bufidx = offset;
        for (retlen = 0; retlen < siz && !this.atEndOfFile(); retlen += rxlen) {
            if (this.m_rxlen == 0 && !this.ReadData()) {
                return -1;
            }
            rxlen = siz;
            if (rxlen > this.m_rxlen) {
                rxlen = this.m_rxlen;
            }
            byte[] pktbuf = this.m_rxpkt.getBuffer();
            for (int idx = 0; idx < rxlen; ++idx) {
                buf[bufidx + idx] = pktbuf[this.m_rxoffset + idx];
            }
            this.m_rxlen -= rxlen;
            this.m_rxoffset += rxlen;
            bufidx += rxlen;
        }
        return retlen;
    }

    private final boolean ReadData() {
        if (this.m_rxpkt == null) {
            this.m_rxpkt = new SMBPacket();
            this.m_rxpkt.setUserId(this.m_sess.getUserId());
            this.m_rxpkt.setTreeId(this.m_sess.getTreeId());
        }
        this.m_rxpkt.setCommand(10);
        this.m_rxpkt.setParameterCount(5);
        this.m_rxpkt.setParameter(0, this.m_FID);
        if (this.m_rxpos + 4000L > this.getFileSize()) {
            this.m_rxpkt.setParameter(1, (int)(this.getFileSize() - this.m_rxpos));
        } else {
            this.m_rxpkt.setParameter(1, 4000);
        }
        this.m_rxpkt.setParameter(2, (int)this.m_rxpos & 0xFFFF);
        this.m_rxpkt.setParameter(3, (int)(this.m_rxpos & 0xFFFFFFFFFFFF0000L) >> 16);
        this.m_rxpkt.setParameter(4, 4000);
        try {
            this.m_rxpkt.ExchangeSMB(this.m_sess, this.m_rxpkt);
        }
        catch (SMBException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        if (this.m_rxpkt.isValidResponse()) {
            int rxlen = this.m_rxpkt.getParameter(0);
            this.m_rxoffset = this.m_rxpkt.getByteOffset();
            byte[] buf = this.m_rxpkt.getBuffer();
            if (buf[this.m_rxoffset++] != 1) {
                return false;
            }
            this.m_rxlen = DataPacker.getIntelShort(buf, this.m_rxoffset);
            this.m_rxoffset += 2;
            this.m_rxpos += (long)this.m_rxlen;
            if (this.m_rxlen == 0) {
                this.setStateFlag(1, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public int Write(byte[] buf, int siz, int offset) throws IOException, SMBException {
        if (this.isClosed()) {
            return 0;
        }
        if (this.m_txpkt == null) {
            this.m_txpkt = new SMBPacket();
            this.m_txpkt.setUserId(this.m_sess.getUserId());
            this.m_txpkt.setTreeId(this.m_sess.getTreeId());
            this.m_txpkt.setParameterCount(5);
            this.m_txlen = 0;
            this.m_txoffset = 52;
        }
        int txlen = 0;
        byte[] pktbuf = this.m_txpkt.getBuffer();
        while (txlen < siz) {
            int len = pktbuf.length - this.m_txoffset;
            if (len > siz - txlen) {
                len = siz - txlen;
            }
            for (int idx = 0; idx < len; ++idx) {
                pktbuf[this.m_txoffset++] = buf[offset++];
            }
            txlen += len;
            this.m_txlen += len;
            if (this.m_txoffset < pktbuf.length) continue;
            this.WriteData();
        }
        return txlen;
    }

    private final boolean WriteData() {
        this.m_txpkt.setCommand(11);
        this.m_txpkt.setParameterCount(5);
        this.m_txpkt.setParameter(0, this.m_FID);
        this.m_txpkt.setParameter(1, this.m_txlen);
        this.m_txpkt.setParameter(2, (int)this.m_txpos & 0xFFFF);
        this.m_txpkt.setParameter(3, (int)(this.m_txpos & 0xFFFFFFFFFFFF0000L) >> 16);
        this.m_txpkt.setParameter(4, this.m_txlen);
        this.m_txpkt.setByteCount(this.m_txlen + 3);
        byte[] buf = this.m_txpkt.getBuffer();
        int bytoff = this.m_txpkt.getByteOffset();
        buf[bytoff++] = 1;
        DataPacker.putIntelShort(this.m_txlen, buf, bytoff);
        try {
            this.m_txpkt.ExchangeSMB(this.m_sess, this.m_txpkt);
        }
        catch (SMBException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        if (this.m_txpkt.isValidResponse()) {
            int txlen = this.m_txpkt.getParameter(0);
            this.m_txpos += (long)txlen;
            this.m_txlen = 0;
            this.m_txoffset = 52;
            return true;
        }
        return false;
    }

    @Override
    public long Seek(long pos, int typ) throws IOException, SMBException {
        if (this.isClosed()) {
            throw new IOException("Seek on closed file");
        }
        this.Flush();
        this.m_txpkt.setCommand(18);
        this.m_txpkt.setParameterCount(4);
        this.m_txpkt.setParameter(0, this.m_FID);
        this.m_txpkt.setParameter(1, typ);
        this.m_txpkt.setParameterLong(2, (int)pos & 0xFFFFFFFF);
        this.m_txpkt.setByteCount(0);
        this.m_txpkt.ExchangeSMB(this.m_sess, this.m_txpkt);
        if (this.m_txpkt.isValidResponse()) {
            int filePos = this.m_txpkt.getParameter(0) + (this.m_txpkt.getParameter(1) << 16);
            this.m_txpos = filePos;
            this.m_rxpos = filePos;
            this.m_txlen = 0;
            this.m_rxlen = 0;
            return filePos;
        }
        return -1L;
    }

    @Override
    public void Lock(long offset, long len) throws IOException, SMBException {
    }

    @Override
    public void Unlock(long offset, long len) throws IOException, SMBException {
    }
}

