/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client;

import org.filesys.client.AsynchRequest;
import org.filesys.client.CIFSDiskSession;
import org.filesys.client.NTTransPacket;
import org.filesys.client.SMBPacket;
import org.filesys.client.Session;
import org.filesys.client.smb.DirectoryWatcher;
import org.filesys.util.DataPacker;

public class NotifyChangeAsynchRequest
extends AsynchRequest {
    private static String[] _actionName = new String[]{"Added", "Removed", "Modified", "Rename New", "Rename Old"};
    private int m_fid;
    private int m_filter;
    private boolean m_watchTree;
    private DirectoryWatcher m_handler;

    protected NotifyChangeAsynchRequest(int mid, int fid, int filter, boolean watchTree, DirectoryWatcher handler) {
        super(mid, "NotifyChange");
        this.m_fid = fid;
        this.m_filter = filter;
        this.m_watchTree = watchTree;
        this.m_handler = handler;
    }

    public final int getFileId() {
        return this.m_fid;
    }

    public final int getFilter() {
        return this.m_filter;
    }

    public final boolean hasWatchTree() {
        return this.m_watchTree;
    }

    @Override
    protected final void processResponse(Session sess, SMBPacket pkt) {
        if (pkt.getCommand() != 160) {
            return;
        }
        NTTransPacket tpkt = new NTTransPacket(pkt.getBuffer());
        int tcnt = tpkt.getParameterBlockCount();
        if (tcnt > 0) {
            tpkt.resetParameterBlockPointer();
            int nextOff = -1;
            int action = -1;
            int nameLen = -1;
            int startPos = tpkt.getPosition();
            int endPos = startPos + tcnt;
            do {
                nextOff = tpkt.unpackInt();
                action = tpkt.unpackInt();
                nameLen = tpkt.unpackInt();
                String fname = DataPacker.getUnicodeString(tpkt.getBuffer(), tpkt.getPosition(), nameLen / 2);
                try {
                    this.m_handler.directoryChanged(action, fname);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (nextOff == 0) continue;
                tpkt.setPosition(startPos += nextOff);
            } while (nextOff != 0 && tpkt.getPosition() < endPos);
        } else {
            try {
                this.m_handler.directoryChanged(-1, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected final boolean resubmitRequest(Session sess, SMBPacket pkt) {
        boolean sts = false;
        if (sess.isActive() && sess instanceof CIFSDiskSession) {
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            try {
                cifsSess.NTNotifyChange(this);
                sts = true;
            }
            catch (Exception ex) {
                this.setCompleted(true);
            }
        }
        return sts;
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getId());
        str.append(":");
        str.append(this.getName());
        str.append(":");
        str.append(this.hasCompleted() ? "Completed" : "Pending");
        str.append(",FID=");
        str.append(this.getFileId());
        str.append(",filter=0x");
        str.append(Integer.toHexString(this.getFilter()));
        if (this.hasWatchTree()) {
            str.append(",Tree");
        }
        if (this.hasAutoReset()) {
            str.append(",Auto");
        }
        str.append("]");
        return str.toString();
    }
}

