/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.ftp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import org.filesys.debug.Debug;
import org.filesys.ftp.FTPConfigSection;
import org.filesys.ftp.FTPDataSession;
import org.filesys.ftp.FTPDataSessionTable;
import org.filesys.ftp.FTPPath;
import org.filesys.ftp.FTPSessionList;
import org.filesys.ftp.FTPSiteInterface;
import org.filesys.ftp.FTPSrvSession;
import org.filesys.ftp.InvalidPathException;
import org.filesys.server.SrvSession;
import org.filesys.server.Version;
import org.filesys.server.config.ConfigurationListener;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.SharedDeviceList;
import org.filesys.server.filesys.NetworkFileServer;
import org.filesys.util.UTF8Normalizer;

public class FTPServer
extends NetworkFileServer
implements Runnable,
ConfigurationListener {
    private static final String ServerVersion = Version.FTPServerVersion;
    protected static final int LISTEN_BACKLOG = 10;
    protected static final int SERVER_PORT = 21;
    protected static final ThreadGroup FTPThreadGroup = new ThreadGroup("FTPSessions");
    private FTPConfigSection m_configSection;
    private ServerSocket m_srvSock;
    private FTPSessionList m_sessions;
    private FTPDataSessionTable m_dataSessions;
    private int m_dataPortId;
    private SharedDeviceList m_shares;
    private int m_sessId;
    private FTPPath m_rootPath;
    private Thread m_srvThread;
    private FTPSiteInterface m_siteInterface;
    private UTF8Normalizer m_normalizer;

    public FTPServer(ServerConfiguration config) {
        super("FTP", config);
        this.getConfiguration().addListener(this);
        this.setVersion(ServerVersion);
        this.m_sessions = new FTPSessionList();
        this.m_dataSessions = new FTPDataSessionTable();
        this.m_configSection = (FTPConfigSection)config.getConfigSection("FTP");
        if (this.m_configSection != null) {
            this.m_dataPortId = this.getFTPConfiguration().getFTPDataPortLow();
            if (!this.getFTPConfiguration().getFTPDebug().isEmpty()) {
                this.setDebug(true);
            }
            if (this.getFTPConfiguration().hasFTPRootPath()) {
                try {
                    this.m_rootPath = new FTPPath(this.getFTPConfiguration().getFTPRootPath());
                }
                catch (InvalidPathException ex) {
                    Debug.println(ex);
                }
            }
            this.setSiteInterface(this.getFTPConfiguration().getFTPSiteInterface());
        } else {
            this.setEnabled(false);
        }
        try {
            this.m_normalizer = new UTF8Normalizer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void addSession(FTPSrvSession sess) {
        this.m_sessions.addSession(sess);
        if (this.hasDebug()) {
            sess.setDebug(this.getFTPConfiguration().getFTPDebug());
        }
    }

    protected final void removeSession(FTPSrvSession sess) {
        if (this.m_sessions.removeSession(sess) != null) {
            this.fireSessionClosedEvent(sess);
        }
    }

    protected final FTPDataSession allocateDataSession(FTPSrvSession sess, InetAddress remAddr, int remPort) throws IOException {
        FTPDataSession dataSess = null;
        if (!this.getFTPConfiguration().hasFTPDataPortRange()) {
            dataSess = new FTPDataSession(sess, remAddr, remPort);
            return dataSess;
        }
        int dataPortLow = this.getFTPConfiguration().getFTPDataPortLow();
        int dataPortHigh = this.getFTPConfiguration().getFTPDataPortHigh();
        if (this.m_dataSessions.numberOfSessions() == dataPortHigh - dataPortLow) {
            throw new IOException("No free data session ports");
        }
        int dataPort = this.getNextFreeDataSessionPort();
        if (dataPort == -1) {
            throw new IOException("Failed to allocate data port");
        }
        dataSess = new FTPDataSession(sess, dataPort, remAddr, remPort);
        this.m_dataSessions.addSession(dataPort, dataSess);
        if (sess.hasDebug(FTPSrvSession.Dbg.DATAPORT)) {
            Debug.println("[FTP] Allocated data port " + dataPort + " to session " + sess.getSessionId());
        }
        return dataSess;
    }

    protected final FTPDataSession allocatePassiveDataSession(FTPSrvSession sess, InetAddress localAddr) throws IOException {
        FTPDataSession dataSess = null;
        if (!this.getFTPConfiguration().hasFTPDataPortRange()) {
            dataSess = new FTPDataSession(sess, localAddr);
            return dataSess;
        }
        int dataPortLow = this.getFTPConfiguration().getFTPDataPortLow();
        int dataPortHigh = this.getFTPConfiguration().getFTPDataPortHigh();
        if (this.m_dataSessions.numberOfSessions() == dataPortHigh - dataPortLow) {
            throw new IOException("No free data session ports");
        }
        int dataPort = this.getNextFreeDataSessionPort();
        if (dataPort == -1) {
            throw new IOException("Failed to allocate data port");
        }
        dataSess = new FTPDataSession(sess, dataPort, localAddr);
        this.m_dataSessions.addSession(dataPort, dataSess);
        if (sess.hasDebug(FTPSrvSession.Dbg.DATAPORT)) {
            Debug.println("[FTP] Allocated passive data port " + dataPort + " to session " + sess.getSessionId());
        }
        return dataSess;
    }

    protected final void releaseDataSession(FTPDataSession dataSess) {
        dataSess.closeSession();
        if (!this.getFTPConfiguration().hasFTPDataPortRange()) {
            return;
        }
        this.m_dataSessions.removeSession(dataSess);
        if (dataSess.getCommandSession().hasDebug(FTPSrvSession.Dbg.DATAPORT)) {
            Debug.println("[FTP] Released data port " + dataSess.getAllocatedPort() + " for session " + dataSess.getCommandSession().getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getNextFreeDataSessionPort() {
        int initPort = this.m_dataPortId;
        int dataPort = -1;
        int dataHigh = this.getFTPConfiguration().getFTPDataPortHigh();
        FTPDataSessionTable fTPDataSessionTable = this.m_dataSessions;
        synchronized (fTPDataSessionTable) {
            if (this.m_dataPortId > dataHigh) {
                this.m_dataPortId = this.getFTPConfiguration().getFTPDataPortLow();
                initPort = dataHigh;
            }
            dataPort = this.m_dataPortId++;
            while (this.m_dataSessions.findSession(dataPort) != null) {
                if (this.m_dataPortId == initPort) {
                    return -1;
                }
                if (this.m_dataPortId > dataHigh) {
                    this.m_dataPortId = this.getFTPConfiguration().getFTPDataPortLow();
                }
                ++this.m_dataPortId;
            }
        }
        return dataPort <= dataHigh ? dataPort : -1;
    }

    public final String getServerName() {
        return this.getConfiguration().getServerName();
    }

    public final SharedDeviceList getShareList() {
        if (this.m_shares == null) {
            this.m_shares = this.getShareMapper().getShareList(this.getConfiguration().getServerName(), null, false);
        }
        return this.m_shares;
    }

    public final boolean hasBindAddress() {
        return this.getFTPConfiguration().getFTPBindAddress() != null;
    }

    public final InetAddress getBindAddress() {
        return this.getFTPConfiguration().getFTPBindAddress();
    }

    public final boolean hasRootPath() {
        return this.m_rootPath != null;
    }

    public final boolean allowAnonymous() {
        return this.getFTPConfiguration().allowAnonymousFTP();
    }

    public final String getAnonymousAccount() {
        return this.getFTPConfiguration().getAnonymousFTPAccount();
    }

    protected final synchronized int getNextSessionId() {
        return this.m_sessId++;
    }

    protected final FTPConfigSection getFTPConfiguration() {
        return this.m_configSection;
    }

    public final int getPort() {
        return this.getFTPConfiguration().getFTPPort();
    }

    protected final ServerSocket getSocket() {
        return this.m_srvSock;
    }

    public final FTPPath getRootPath() {
        return this.m_rootPath;
    }

    protected final void sessionLoggedOn(SrvSession sess) {
        this.fireSessionLoggedOnEvent(sess);
    }

    @Override
    public void run() {
        if (this.hasDebug()) {
            Debug.println("[FTP] FTP Server starting on port " + this.getPort());
            Debug.println("[FTP] Version " + this.isVersion());
        }
        try {
            this.m_srvSock = this.hasBindAddress() ? new ServerSocket(this.getPort(), 10, this.getBindAddress()) : new ServerSocket(this.getPort(), 10);
            if (this.hasDebug()) {
                InetAddress localSocketAddress = ((InetSocketAddress)this.m_srvSock.getLocalSocketAddress()).getAddress();
                Debug.println("[FTP] Listening on " + localSocketAddress);
            }
            if (this.hasDebug() && this.getFTPConfiguration().hasFTPDataPortRange()) {
                Debug.println("[FTP] Data ports restricted to range " + this.getFTPConfiguration().getFTPDataPortLow() + " - " + this.getFTPConfiguration().getFTPDataPortHigh());
            }
            if (this.hasDebug() && this.getFTPConfiguration().isFTPSEnabled()) {
                Debug.println("[FTP] FTPS support enabled (" + (this.getFTPConfiguration().requireSecureSession() ? "required" : "optional") + ")");
            }
            this.setActive(true);
            this.fireServerEvent(1);
            while (!this.hasShutdown()) {
                Socket sessSock = this.getSocket().accept();
                sessSock.setTcpNoDelay(true);
                if (this.hasDebug()) {
                    Debug.println("[FTP] FTP session request received from " + sessSock.getInetAddress().getHostAddress());
                }
                FTPSrvSession srvSess = new FTPSrvSession(sessSock, this);
                srvSess.setSessionId(this.getNextSessionId());
                srvSess.setUniqueId("FTP" + srvSess.getSessionId());
                srvSess.setDebugPrefix("[FTP" + srvSess.getSessionId() + "] ");
                if (this.hasRootPath()) {
                    srvSess.setRootPath(this.getRootPath());
                }
                this.addSession(srvSess);
                this.fireSessionOpenEvent(srvSess);
                Thread srvThread = new Thread(FTPThreadGroup, srvSess);
                srvThread.setDaemon(true);
                srvThread.setName("Sess_FTP" + srvSess.getSessionId() + "_" + sessSock.getInetAddress().getHostAddress());
                srvThread.start();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (SocketException ex) {
            if (!this.hasShutdown()) {
                Debug.println("[FTP] FTP Socket error : " + ex.toString(), 1);
                Debug.println(ex);
                this.setException(ex);
                this.fireServerEvent(3);
            }
        }
        catch (Exception ex) {
            if (!this.hasShutdown()) {
                Debug.println("[FTP] FTP Server error : " + ex.toString(), 1);
                Debug.println(ex);
            }
            this.setException(ex);
            this.fireServerEvent(3);
        }
        Enumeration<Integer> enm = this.m_sessions.enumerate();
        while (enm.hasMoreElements()) {
            Integer sessId = enm.nextElement();
            FTPSrvSession sess = this.m_sessions.findSession(sessId);
            if (this.hasDebug()) {
                Debug.println("[FTP] FTP Close session, id = " + sess.getSessionId());
            }
            sess.closeSession();
        }
        if (this.hasDebug()) {
            Debug.println("[FTP] FTP Server shutting down ...");
        }
        this.setActive(false);
        this.fireServerEvent(2);
    }

    @Override
    public void shutdownServer(boolean immediate) {
        this.setShutdown(true);
        try {
            if (this.getSocket() != null) {
                this.getSocket().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.m_srvThread != null) {
            try {
                this.m_srvThread.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_configSection.closeConfig();
        this.fireServerEvent(2);
    }

    @Override
    public void startServer() {
        this.m_srvThread = new Thread(this);
        this.m_srvThread.setName("FTP Server");
        this.m_srvThread.start();
        this.fireServerEvent(0);
    }

    @Override
    public int configurationChanged(int id, ServerConfiguration config, Object newVal) throws InvalidConfigurationException {
        int sts = 0;
        try {
            switch (id) {
                case 65538: {
                    Boolean enaFTP = (Boolean)newVal;
                    if (this.isActive() && !enaFTP.booleanValue()) {
                        this.shutdownServer(false);
                    } else if (!this.isActive() && enaFTP.booleanValue()) {
                        this.startServer();
                    }
                    sts = 1;
                    break;
                }
                case 196614: {
                    Boolean dbg = (Boolean)newVal;
                    this.setDebug(dbg);
                    sts = 1;
                    break;
                }
                case 65540: 
                case 65541: 
                case 196611: 
                case 196630: 
                case 393217: 
                case 393218: 
                case 458753: 
                case 524289: 
                case 589825: {
                    sts = 1;
                    break;
                }
                case 196613: {
                    sts = 2;
                    break;
                }
                case 196609: 
                case 196610: {
                    sts = 3;
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("FTP Server configuration error", ex);
        }
        return sts;
    }

    public final boolean hasSiteInterface() {
        return this.m_siteInterface != null;
    }

    public final FTPSiteInterface getSiteInterface() {
        return this.m_siteInterface;
    }

    public final void setSiteInterface(FTPSiteInterface siteInterface) {
        this.m_siteInterface = siteInterface;
    }

    public final boolean hasUTF8Normalizer() {
        return this.m_normalizer != null;
    }

    public final UTF8Normalizer getUTF8Normalizer() {
        return this.m_normalizer;
    }
}

