/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.locking;

import java.io.Serializable;
import java.util.ArrayList;
import org.filesys.locking.FileLock;

public class FileLockList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<FileLock> m_lockList = new ArrayList();

    public final void addLock(FileLock lock) {
        this.m_lockList.add(lock);
    }

    public final FileLock findLock(FileLock lock) {
        return this.findLock(lock.getOffset(), lock.getLength(), lock.getProcessId());
    }

    public final FileLock findLock(long offset, long len, int pid) {
        if (this.numberOfLocks() == 0) {
            return null;
        }
        FileLock fLock = null;
        for (int i = 0; i < this.numberOfLocks(); ++i) {
            fLock = this.getLockAt(i);
            if (fLock.getOffset() != offset || fLock.getLength() != len) continue;
            return fLock;
        }
        return null;
    }

    public final FileLock removeLock(FileLock lock) {
        return this.removeLock(lock.getOffset(), lock.getLength(), lock.getProcessId());
    }

    public final FileLock removeLock(long offset, long len, int pid) {
        if (this.numberOfLocks() == 0) {
            return null;
        }
        for (int i = 0; i < this.numberOfLocks(); ++i) {
            FileLock curLock = this.getLockAt(i);
            if (curLock.getOffset() != offset || curLock.getLength() != len) continue;
            this.m_lockList.remove(i);
            return curLock;
        }
        return null;
    }

    public final void removeAllLocks() {
        this.m_lockList.clear();
    }

    public final FileLock getLockAt(int idx) {
        if (idx < this.m_lockList.size()) {
            return this.m_lockList.get(idx);
        }
        return null;
    }

    public final FileLock removeLockAt(int idx) {
        if (idx < this.m_lockList.size()) {
            return this.m_lockList.remove(idx);
        }
        return null;
    }

    public final boolean allowsLock(FileLock lock) {
        if (this.numberOfLocks() == 0) {
            return true;
        }
        for (int i = 0; i < this.numberOfLocks(); ++i) {
            FileLock curLock = this.getLockAt(i);
            if (!curLock.hasOverlap(lock)) continue;
            return false;
        }
        return true;
    }

    public final boolean canReadFile(FileLock lock) {
        return this.canReadFile(lock.getOffset(), lock.getLength(), lock.getProcessId());
    }

    public final boolean canReadFile(long offset, long len, int pid) {
        if (this.numberOfLocks() == 0) {
            return true;
        }
        for (int i = 0; i < this.numberOfLocks(); ++i) {
            FileLock curLock = this.getLockAt(i);
            if (curLock.getProcessId() == pid || !curLock.hasOverlap(offset, len)) continue;
            return false;
        }
        return true;
    }

    public final boolean canWriteFile(FileLock lock) {
        return this.canWriteFile(lock.getOffset(), lock.getLength(), lock.getProcessId());
    }

    public final boolean canWriteFile(long offset, long len, int pid) {
        if (this.numberOfLocks() == 0) {
            return true;
        }
        for (int i = 0; i < this.numberOfLocks(); ++i) {
            FileLock curLock = this.getLockAt(i);
            if (curLock.getProcessId() == pid || !curLock.hasOverlap(offset, len)) continue;
            return false;
        }
        return true;
    }

    public final int numberOfLocks() {
        return this.m_lockList.size();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Locklist:");
        str.append(this.numberOfLocks());
        if (this.numberOfLocks() > 0) {
            for (int i = 0; i < this.numberOfLocks(); ++i) {
                str.append(this.getLockAt(i));
                str.append(",");
            }
        }
        str.append("]");
        return str.toString();
    }
}

