/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.netbios;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.filesys.netbios.NetBIOSDatagram;
import org.filesys.netbios.NetworkSettings;

public class NetBIOSDatagramSocket {
    private static NetBIOSDatagramSocket m_nbSocket;
    private static int m_defPort;
    private static InetAddress m_defBindAddr;
    private DatagramSocket m_socket = m_defBindAddr == null ? new DatagramSocket(m_defPort) : new DatagramSocket(m_defPort, m_defBindAddr);
    private InetAddress m_broadcastAddr = m_defBindAddr == null ? InetAddress.getByName(NetworkSettings.GenerateBroadcastMask(null)) : InetAddress.getByName(NetworkSettings.GenerateBroadcastMask(m_defBindAddr.getHostAddress()));

    private NetBIOSDatagramSocket() throws SocketException, UnknownHostException {
    }

    public static final synchronized NetBIOSDatagramSocket getInstance() throws SocketException, UnknownHostException {
        if (m_nbSocket == null) {
            m_nbSocket = new NetBIOSDatagramSocket();
        }
        return m_nbSocket;
    }

    public static final void setDefaultPort(int port) {
        m_defPort = port;
    }

    public static final void setBindAddress(InetAddress bindAddr) {
        m_defBindAddr = bindAddr;
    }

    public final int receiveDatagram(NetBIOSDatagram dgram) throws IOException {
        DatagramPacket pkt = new DatagramPacket(dgram.getBuffer(), dgram.getBuffer().length);
        this.m_socket.receive(pkt);
        return pkt.getLength();
    }

    public final void sendDatagram(NetBIOSDatagram dgram, InetAddress destAddr, int destPort) throws IOException {
        DatagramPacket pkt = new DatagramPacket(dgram.getBuffer(), dgram.getLength(), destAddr, destPort);
        this.m_socket.send(pkt);
    }

    public final void sendBroadcastDatagram(NetBIOSDatagram dgram) throws IOException {
        DatagramPacket pkt = new DatagramPacket(dgram.getBuffer(), dgram.getLength(), this.m_broadcastAddr, m_defPort);
        this.m_socket.send(pkt);
    }

    static {
        m_defPort = 138;
    }
}

