/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import org.filesys.debug.Debug;
import org.filesys.oncrpc.AuthType;
import org.filesys.oncrpc.Rpc;
import org.filesys.oncrpc.RpcAuthenticationException;
import org.filesys.oncrpc.RpcAuthenticator;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;

public class DefaultRpcAuthenticator
implements RpcAuthenticator {
    private AuthType[] _authTypes = new AuthType[]{AuthType.Null, AuthType.Unix};
    private boolean m_debug;

    @Override
    public Object authenticateRpcClient(AuthType authType, RpcPacket rpc) throws RpcAuthenticationException {
        Number sessKey = null;
        switch (authType) {
            case Null: {
                sessKey = new Integer(rpc.getClientAddress().hashCode());
                break;
            }
            case Unix: {
                rpc.positionAtCredentialsData();
                rpc.skipBytes(4);
                int nameLen = rpc.unpackInt();
                rpc.skipBytes(nameLen);
                int uid = rpc.unpackInt();
                int gid = rpc.unpackInt();
                sessKey = new Long(((long)rpc.getClientAddress().hashCode() << 32) + (long)(gid << 16) + (long)uid);
            }
        }
        if (sessKey == null) {
            throw new RpcAuthenticationException(Rpc.AuthSts.BadCred, "Unsupported auth type, " + (Object)((Object)authType));
        }
        if (this.hasDebug()) {
            Debug.println("RpcAuth: RPC from " + rpc.getClientDetails() + ", authType=" + authType.name() + ", sessKey=" + sessKey);
        }
        return sessKey;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public AuthType[] getRpcAuthenticationTypes() {
        return this._authTypes;
    }

    @Override
    public ClientInfo getRpcClientInformation(Object sessKey, RpcPacket rpc) {
        ClientInfo cInfo = ClientInfo.createInfo("", null);
        AuthType authType = rpc.getCredentialsType();
        cInfo.setNFSAuthenticationType(authType);
        switch (authType) {
            case Null: {
                cInfo.setClientAddress(rpc.getClientAddress().getHostAddress());
                if (!this.hasDebug()) break;
                Debug.println("RpcAuth: Client info, type=" + authType.name() + ", addr=" + rpc.getClientAddress().getHostAddress());
                break;
            }
            case Unix: {
                rpc.positionAtCredentialsData();
                rpc.skipBytes(4);
                cInfo.setClientAddress(rpc.unpackString());
                cInfo.setUid(rpc.unpackInt());
                cInfo.setGid(rpc.unpackInt());
                int grpLen = rpc.unpackInt();
                if (grpLen > 0) {
                    int[] groups = new int[grpLen];
                    rpc.unpackIntArray(groups);
                    cInfo.setGroupsList(groups);
                }
                if (!this.hasDebug()) break;
                Debug.println("RpcAuth: Client info, type=" + authType.name() + ", name=" + cInfo.getClientAddress() + ", uid=" + cInfo.getUid() + ", gid=" + cInfo.getGid() + ", groups=" + grpLen);
            }
        }
        return cInfo;
    }

    @Override
    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        if (params.getChild("Debug") != null) {
            this.m_debug = true;
        }
    }

    @Override
    public void setCurrentUser(SrvSession sess, ClientInfo client) {
    }
}

