/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.io.IOException;
import java.net.Socket;
import org.filesys.oncrpc.MultiThreadedTcpRpcSessionHandler;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcPacketHandler;
import org.filesys.oncrpc.RpcPacketPool;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.oncrpc.RpcThreadRequest;
import org.filesys.oncrpc.TcpRpcPacketHandler;
import org.filesys.oncrpc.TcpRpcSessionHandler;
import org.filesys.server.core.NoPooledMemoryException;
import org.filesys.server.thread.ThreadRequestPool;

public class MultiThreadedTcpRpcPacketHandler
extends TcpRpcPacketHandler
implements RpcPacketHandler {
    private RpcPacketPool m_packetPool;
    private ThreadRequestPool m_threadPool;

    public MultiThreadedTcpRpcPacketHandler(TcpRpcSessionHandler handler, int sessId, RpcProcessor server, Socket socket, int maxRpcSize, RpcPacketPool pktPool, ThreadRequestPool threadPool) throws IOException {
        super(handler, sessId, server, socket, maxRpcSize);
        this.m_packetPool = pktPool;
        this.m_threadPool = threadPool;
    }

    protected final MultiThreadedTcpRpcSessionHandler getSessionHandler() {
        return (MultiThreadedTcpRpcSessionHandler)this.getHandler();
    }

    @Override
    protected RpcPacket allocateRpcPacket(int maxSize) throws NoPooledMemoryException {
        return this.m_packetPool.allocatePacket(maxSize);
    }

    @Override
    protected void deallocateRpcPacket(RpcPacket pkt) {
        if (pkt.isAllocatedFromPool()) {
            pkt.getOwnerPacketPool().releasePacket(pkt);
        }
    }

    @Override
    protected void processRpc(RpcPacket rpc) throws IOException {
        rpc.setPacketHandler(this);
        this.m_threadPool.queueRequest(new RpcThreadRequest(rpc, this.getRpcProcessor(), this));
    }

    @Override
    public void sendRpcResponse(RpcPacket rpc) throws IOException {
        this.sendRpc(rpc);
    }

    @Override
    public RpcPacket receiveRpc() throws IOException {
        return null;
    }
}

