/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

public class Rpc {
    public static final int LastFragment = Integer.MIN_VALUE;
    public static final int LengthMask = Integer.MAX_VALUE;
    public static final int RpcVersion = 2;
    public static final int True = 1;
    public static final int False = 0;

    public static final String getServiceName(int progId) {
        String svcName = null;
        switch (progId) {
            case 100005: {
                svcName = "Mount";
                break;
            }
            case 100003: {
                svcName = "NFS";
                break;
            }
            case 100000: {
                svcName = "Portmap";
                break;
            }
            default: {
                svcName = "" + progId;
            }
        }
        return svcName;
    }

    public static enum ProtocolId {
        TCP(6),
        UDP(17),
        Invalid(65535);

        private final int protId;

        private ProtocolId(int id) {
            this.protId = id;
        }

        public final int intValue() {
            return this.protId;
        }

        public static final ProtocolId fromInt(int id) {
            ProtocolId prot = Invalid;
            switch (id) {
                case 6: {
                    prot = TCP;
                    break;
                }
                case 17: {
                    prot = UDP;
                }
            }
            return prot;
        }
    }

    public static enum AuthSts {
        BadCred(1),
        RejectCred(2),
        BadVerf(3),
        RejectedVerf(4),
        TooWeak(5),
        Invalid(65535);

        private final int authSts;

        private AuthSts(int sts) {
            this.authSts = sts;
        }

        public final int intValue() {
            return this.authSts;
        }

        public static final AuthSts fromInt(int sts) {
            AuthSts aSts = Invalid;
            switch (sts) {
                case 1: {
                    aSts = BadCred;
                    break;
                }
                case 2: {
                    aSts = RejectCred;
                    break;
                }
                case 3: {
                    aSts = BadVerf;
                    break;
                }
                case 4: {
                    aSts = RejectedVerf;
                    break;
                }
                case 5: {
                    aSts = TooWeak;
                }
            }
            return aSts;
        }
    }

    public static enum RejectSts {
        RpcMismatch(0),
        AuthError(1),
        Invalid(65535);

        private final int rejectSts;

        private RejectSts(int sts) {
            this.rejectSts = sts;
        }

        public final int intValue() {
            return this.rejectSts;
        }

        public static final RejectSts fromInt(int sts) {
            RejectSts rSts = Invalid;
            switch (sts) {
                case 0: {
                    rSts = RpcMismatch;
                    break;
                }
                case 1: {
                    rSts = AuthError;
                }
            }
            return rSts;
        }
    }

    public static enum AcceptSts {
        Success(0),
        ProgUnavail(1),
        ProgMismatch(2),
        ProcUnavail(3),
        BadArgs(4),
        Invalid(65535);

        private final int acceptSts;

        private AcceptSts(int sts) {
            this.acceptSts = sts;
        }

        public final int intValue() {
            return this.acceptSts;
        }

        public static final AcceptSts fromInt(int sts) {
            AcceptSts aSts = Invalid;
            switch (sts) {
                case 0: {
                    aSts = Success;
                    break;
                }
                case 1: {
                    aSts = ProgUnavail;
                    break;
                }
                case 2: {
                    aSts = ProgMismatch;
                    break;
                }
                case 3: {
                    aSts = ProcUnavail;
                    break;
                }
                case 4: {
                    aSts = BadArgs;
                }
            }
            return aSts;
        }
    }

    public static enum CallStatus {
        Accepted(0),
        Denied(1),
        Invalid(65535);

        private final int callSts;

        private CallStatus(int sts) {
            this.callSts = sts;
        }

        public final int intValue() {
            return this.callSts;
        }

        public static final CallStatus fromInt(int sts) {
            CallStatus cSts = Invalid;
            switch (sts) {
                case 0: {
                    cSts = Accepted;
                    break;
                }
                case 1: {
                    cSts = Denied;
                }
            }
            return cSts;
        }
    }

    public static enum MessageType {
        Call(0),
        Reply(1),
        Invalid(65535);

        private final int msgType;

        private MessageType(int typ) {
            this.msgType = typ;
        }

        public final int intValue() {
            return this.msgType;
        }

        public static final MessageType fromInt(int typ) {
            MessageType mType = Invalid;
            switch (typ) {
                case 0: {
                    mType = Call;
                    break;
                }
                case 1: {
                    mType = Reply;
                }
            }
            return mType;
        }
    }
}

