/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.util.HashMap;
import java.util.Iterator;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.server.core.NoPooledMemoryException;
import org.filesys.server.memory.ByteBufferPool;
import org.filesys.server.thread.ThreadRequestPool;
import org.filesys.server.thread.TimedThreadRequest;

public class RpcPacketPool {
    public static final long RpcAllocateWaitTime = 250L;
    public static final long RpcLeaseTime = 5000L;
    public static final long RpcLeaseTimeSecs = 5L;
    private ByteBufferPool m_bufferPool;
    private ThreadRequestPool m_threadPool;
    private HashMap<RpcPacket, RpcPacket> m_leasedPkts = new HashMap();
    private boolean m_debug;
    private boolean m_allocDebug;
    private boolean m_allowOverSize = true;
    private int m_maxOverSize = 131072;
    private int m_maxPoolBufSize;

    public RpcPacketPool(ByteBufferPool bufPool, ThreadRequestPool threadPool) {
        this.m_bufferPool = bufPool;
        this.m_threadPool = threadPool;
        this.m_maxPoolBufSize = this.m_bufferPool.getLargestSize();
        this.m_threadPool.queueTimedRequest(new RpcLeaseExpiryTimedRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RpcPacket allocatePacket(int reqSiz) throws NoPooledMemoryException {
        byte[] buf = null;
        boolean nonPooled = false;
        if (reqSiz <= this.m_maxPoolBufSize) {
            buf = this.m_bufferPool.allocateBuffer(reqSiz, 250L);
        } else if (this.allowsOverSizedAllocations() && reqSiz <= this.getMaximumOverSizedAllocation()) {
            if (this.hasAllocateDebug()) {
                Debug.println("[RPC] Allocating an over-sized packet, reqSiz=" + reqSiz);
            }
            buf = new byte[reqSiz];
            nonPooled = true;
        }
        if (buf == null) {
            if (reqSiz < this.m_maxPoolBufSize) {
                buf = new byte[reqSiz];
                nonPooled = true;
            } else {
                if (this.hasDebug()) {
                    Debug.println("[RPC] Packet allocate failed, reqSiz=" + reqSiz);
                }
                throw new NoPooledMemoryException("Request size " + reqSiz + "/max size=" + this.m_maxPoolBufSize);
            }
        }
        RpcPacket packet = new RpcPacket(buf);
        if (!nonPooled) {
            packet.setOwnerPacketPool(this);
            HashMap<RpcPacket, RpcPacket> hashMap = this.m_leasedPkts;
            synchronized (hashMap) {
                packet.setLeaseTime(System.currentTimeMillis() + 5000L);
                this.m_leasedPkts.put(packet, packet);
            }
        }
        return packet;
    }

    public final RpcPacket allocateAssociatedPacket(int reqSiz, RpcPacket assocRpc, int copyLen) throws NoPooledMemoryException {
        RpcPacket packet = this.allocatePacket(reqSiz);
        if (packet == null) {
            return packet;
        }
        assocRpc.setAssociatedPacket(packet);
        if (copyLen > 0) {
            System.arraycopy(assocRpc.getBuffer(), 0, packet.getBuffer(), 0, copyLen);
        } else if (copyLen == -1) {
            System.arraycopy(assocRpc.getBuffer(), 0, packet.getBuffer(), 0, assocRpc.getRequestHeaderLength());
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releasePacket(RpcPacket rpcPkt) {
        if (rpcPkt.hasLeaseTime()) {
            if (this.hasDebug() && rpcPkt.getLeaseTime() < System.currentTimeMillis()) {
                Debug.println("[RPC] Release expired packet: pkt=" + rpcPkt);
            }
            HashMap<RpcPacket, RpcPacket> hashMap = this.m_leasedPkts;
            synchronized (hashMap) {
                rpcPkt.clearLeaseTime();
                this.m_leasedPkts.remove(rpcPkt);
            }
        }
        if (rpcPkt.getBuffer().length <= this.m_maxPoolBufSize && rpcPkt.isAllocatedFromPool()) {
            this.m_bufferPool.releaseBuffer(rpcPkt.getBuffer());
            if (this.hasAllocateDebug()) {
                Debug.println("[RPC] Packet released bufSiz=" + rpcPkt.getBuffer().length);
            }
        } else if (this.hasAllocateDebug()) {
            Debug.println("[RPC] Non-pooled packet left for garbage collector, size=" + rpcPkt.getBuffer().length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkForExpiredLeases() {
        block7: {
            try {
                if (!this.hasDebug()) break block7;
                HashMap<RpcPacket, RpcPacket> hashMap = this.m_leasedPkts;
                synchronized (hashMap) {
                    if (!this.m_leasedPkts.isEmpty()) {
                        Iterator<RpcPacket> leaseIter = this.m_leasedPkts.keySet().iterator();
                        long timeNow = System.currentTimeMillis();
                        while (leaseIter.hasNext()) {
                            RpcPacket curPkt = leaseIter.next();
                            if (!curPkt.hasLeaseTime() || curPkt.getLeaseTime() >= timeNow) continue;
                            Debug.println("[RPC] Packet lease expired, pkt=" + curPkt);
                        }
                    }
                }
            }
            catch (Throwable ex) {
                Debug.println(ex);
            }
        }
    }

    public final ByteBufferPool getBufferPool() {
        return this.m_bufferPool;
    }

    public final int getSmallestSize() {
        return this.m_bufferPool.getSmallestSize();
    }

    public final int getLargestSize() {
        return this.m_bufferPool.getLargestSize();
    }

    public final boolean allowsOverSizedAllocations() {
        return this.m_allowOverSize;
    }

    public final int getMaximumOverSizedAllocation() {
        return this.m_maxOverSize;
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final void setAllocateDebug(boolean ena) {
        this.m_allocDebug = ena;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final boolean hasAllocateDebug() {
        return this.m_allocDebug;
    }

    public final void setAllowOverSizedAllocations(boolean ena) {
        this.m_allowOverSize = ena;
    }

    public final void setMaximumOverSizedAllocation(int maxSize) {
        this.m_maxOverSize = maxSize;
    }

    public String toString() {
        return this.m_bufferPool.toString();
    }

    private class RpcLeaseExpiryTimedRequest
    extends TimedThreadRequest {
        public RpcLeaseExpiryTimedRequest() {
            super("RpcPacketPoolExpiry", -5L, 5L);
        }

        @Override
        protected void runTimedRequest() {
            RpcPacketPool.this.checkForExpiredLeases();
        }
    }
}

