/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.filesys.oncrpc.nfs.RpcSessionProcessor;

public class RpcProcessorFactory {
    private static HashMap<Integer, HashMap<Integer, Class>> _processorMap = new HashMap(4);

    private RpcProcessorFactory() {
    }

    public static final boolean supportsRpcProgram(int progId) {
        if (_processorMap == null) {
            return false;
        }
        return _processorMap.containsKey(progId);
    }

    public static final boolean supportsRpcVersion(int progId, int verId) {
        if (_processorMap == null) {
            return false;
        }
        HashMap<Integer, Class> versionMap = _processorMap.get(progId);
        if (versionMap != null) {
            return versionMap.containsKey(verId);
        }
        return false;
    }

    public static final int[] getSupportedVersionRange(int progId) {
        int[] vers = new int[2];
        if (_processorMap != null) {
            HashMap<Integer, Class> versionMap = _processorMap.get(progId);
            if (versionMap != null) {
                Set<Integer> availVers = versionMap.keySet();
                Iterator<Integer> verIter = availVers.iterator();
                if (availVers.size() == 1) {
                    vers[0] = verIter.next();
                    vers[1] = vers[0];
                } else {
                    vers[0] = verIter.next();
                    while (verIter.hasNext()) {
                        vers[1] = verIter.next();
                    }
                }
            }
        } else {
            vers[0] = -1;
            vers[1] = -1;
        }
        return vers;
    }

    public static RpcSessionProcessor getRpcSessionProcessor(int progId, int verId) {
        if (_processorMap == null) {
            return null;
        }
        HashMap<Integer, Class> versionMap = _processorMap.get(progId);
        if (versionMap != null) {
            try {
                Class rpcProcClass = versionMap.get(verId);
                if (rpcProcClass != null) {
                    RpcSessionProcessor rpcProc = (RpcSessionProcessor)rpcProcClass.newInstance();
                    return rpcProc;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void addRpcProcessorClass(int progId, int verId, Class rpcProcClass) {
        try {
            if (rpcProcClass == null || !(rpcProcClass.newInstance() instanceof RpcSessionProcessor)) {
                throw new RuntimeException("Invalid RPC processor class");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error checking RPC processor class type");
        }
        if (_processorMap == null) {
            throw new RuntimeException("Invalid RPC processor map");
        }
        HashMap<Integer, Class<Object>> versionMap = _processorMap.get(progId);
        if (versionMap == null) {
            versionMap = new HashMap(4);
            _processorMap.put(progId, versionMap);
        }
        versionMap.put(verId, rpcProcClass);
    }
}

