/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import org.filesys.debug.Debug;
import org.filesys.oncrpc.Rpc;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcPacketHandler;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.server.thread.ThreadRequest;

public class RpcThreadRequest
implements ThreadRequest {
    private RpcPacket m_rpc;
    private RpcProcessor m_processor;
    private RpcPacketHandler m_handler;

    public RpcThreadRequest(RpcPacket rpc, RpcProcessor rpcProc, RpcPacketHandler rpcHandler) {
        this.m_rpc = rpc;
        this.m_processor = rpcProc;
        this.m_handler = rpcHandler;
    }

    @Override
    public void runRequest() {
        if (this.m_rpc != null) {
            RpcPacket response = null;
            try {
                response = this.m_processor.processRpc(this.m_rpc);
                if (response != null) {
                    this.m_rpc.getPacketHandler().sendRpcResponse(response);
                }
            }
            catch (Throwable ex) {
                Debug.println("[RPC] Error processing RPC");
                Debug.println(ex);
            }
            finally {
                if (this.m_rpc.getClientProtocol() == Rpc.ProtocolId.TCP) {
                    if (this.m_rpc.isAllocatedFromPool()) {
                        this.m_rpc.getOwnerPacketPool().releasePacket(this.m_rpc);
                    }
                    if (response != null && response.getBuffer() != this.m_rpc.getBuffer() && response.isAllocatedFromPool()) {
                        response.getOwnerPacketPool().releasePacket(response);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[RPC rpc=");
        str.append(this.m_rpc);
        str.append("]");
        return str.toString();
    }
}

