/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.filesys.oncrpc.Rpc;
import org.filesys.oncrpc.RpcClient;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.TcpRpcPacketHandler;

public class TcpRpcClient
extends RpcClient {
    private TcpRpcPacketHandler m_client;

    public TcpRpcClient(InetAddress addr, int port, int maxRpcSize) throws IOException {
        super(addr, port, Rpc.ProtocolId.TCP, maxRpcSize);
        Socket sock = new Socket();
        sock.setReuseAddress(true);
        sock.setSoLinger(false, 0);
        sock.connect(new InetSocketAddress(addr, port));
        this.m_client = new TcpRpcPacketHandler(sock, maxRpcSize);
    }

    public TcpRpcClient(InetAddress addr, int port, InetAddress fromAddr, int fromPort, int maxRpcSize) throws IOException {
        super(addr, port, Rpc.ProtocolId.TCP, maxRpcSize);
        Socket sock = new Socket();
        sock.setReuseAddress(true);
        sock.setSoLinger(false, 0);
        sock.bind(new InetSocketAddress(fromAddr, fromPort));
        sock.connect(new InetSocketAddress(addr, port));
        this.m_client = new TcpRpcPacketHandler(sock, maxRpcSize);
    }

    @Override
    public RpcPacket sendRPC(RpcPacket rpc, RpcPacket rxRpc) throws IOException {
        this.m_client.sendRpc(rpc);
        RpcPacket rxPkt = rxRpc;
        if (rxPkt == null) {
            rxPkt = new RpcPacket(this.getMaximumRpcSize());
        }
        this.m_client.receiveRpc(rxPkt);
        return rxPkt;
    }

    @Override
    public void closeConnection() {
        if (this.m_client != null) {
            this.m_client.closePacketHandler();
            this.m_client = null;
        }
    }
}

